/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.services.encryptcache.tasks;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.text.CharSequenceUtil;
import cn.smarthse.es.esservice.IOrigiCipIdEsService;
import cn.smarthse.es.model.OrigiCipIdModel;
import cn.smarthse.es.model.OrigiCipIdParamModel;
import cn.smarthse.modules.common.cache.IEncryptCacheService;
import cn.smarthse.services.encryptcache.component.EncryptCacheServiceImpl;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.xxl.job.core.context.XxlJobHelper;
import com.xxl.job.core.handler.annotation.XxlJob;
import java.util.Collection;
import java.util.List;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.rocksdb.RocksDBException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class LoadEncryptCacheTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LoadEncryptCacheTask.class);
    @DubboReference
    IOrigiCipIdEsService esService;
    @Autowired
    EncryptCacheServiceImpl encryptCacheHolder;
    @Autowired
    IEncryptCacheService encryptCacheService;
    int pageSize = 10000;

    @XxlJob(value="LoadEncryptCacheTask-loadEncrypt2Cache")
    public void loadEncrypt2Cache() throws RocksDBException {
        List origiCipIdModels;
        OrigiCipIdParamModel paras = new OrigiCipIdParamModel();
        int pageNum = 0;
        while (!CollectionUtils.isEmpty((Collection)(origiCipIdModels = this.esService.deepPage(paras, this.pageSize)))) {
            for (OrigiCipIdModel origiCipIdModel : origiCipIdModels) {
                this.encryptCacheHolder.put(origiCipIdModel.getCipData(), origiCipIdModel.getOrgiData());
            }
            XxlJobHelper.log((String)"\u52a0\u8f7d\u5b8c\u6210\u7b2c{}\u9875\u6570\u636e, offset:{}, size:{}", (Object[])new Object[]{++pageNum, ((OrigiCipIdModel)origiCipIdModels.get(origiCipIdModels.size() - 1)).getOrgiData(), origiCipIdModels.size()});
            log.error("\u52a0\u8f7d\u5b8c\u6210\u7b2c{}\u9875\u6570\u636e, offset:{}, size:{}", new Object[]{pageNum, ((OrigiCipIdModel)origiCipIdModels.get(origiCipIdModels.size() - 1)).getOrgiData(), origiCipIdModels.size()});
            if (origiCipIdModels.size() < this.pageSize) break;
            paras.setStartId(((OrigiCipIdModel)origiCipIdModels.get(origiCipIdModels.size() - 1)).getOrgiData());
        }
    }

    @XxlJob(value="LoadEncryptCacheTask-decrypt")
    public void decrypt(String decrypt, String showLog) {
        if (CharSequenceUtil.isBlank((CharSequence)decrypt)) {
            decrypt = this.getParamValue("decrypt");
        }
        if (CharSequenceUtil.isBlank((CharSequence)showLog)) {
            showLog = this.getParamValue("showLog");
        }
        String encrypt = this.encryptCacheService.decrypt(decrypt, Convert.toBool((Object)showLog));
        XxlJobHelper.log((String)encrypt, (Object[])new Object[0]);
        log.error(encrypt);
    }

    private String getParamValue(String paramName) {
        JSONObject jsonObj;
        String paramValue = null;
        String jobParam = XxlJobHelper.getJobParam();
        if (CharSequenceUtil.isNotBlank((CharSequence)jobParam) && (jsonObj = JSON.parseObject((String)jobParam)) != null) {
            paramValue = jsonObj.getString(paramName);
        }
        return paramValue;
    }
}

