/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.services.encryptcache.storage;

import cn.hutool.core.util.StrUtil;
import cn.smarthse.encrypt.spring.utils.SpringEncryptUtils;
import cn.smarthse.services.encryptcache.config.RocksDBConfig;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.rocksdb.CompressionType;
import org.rocksdb.Options;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RocksDBEncryptCache {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RocksDBEncryptCache.class);
    private RocksDB db;
    private final RocksDBConfig rocksDBConfig;

    @Autowired
    public RocksDBEncryptCache(RocksDBConfig rocksDBConfig) {
        this.rocksDBConfig = rocksDBConfig;
    }

    @PostConstruct
    public void init() {
        try (Options options = new Options();){
            RocksDB.loadLibrary();
            options.setCreateIfMissing(true);
            options.setMaxOpenFiles(this.rocksDBConfig.getMaxOpenFiles().intValue());
            options.setWriteBufferSize(this.rocksDBConfig.getWriteBufferSize().longValue());
            options.setMaxWriteBufferNumber(this.rocksDBConfig.getMaxWriteBufferNumber().intValue());
            options.setTargetFileSizeBase(this.rocksDBConfig.getTargetFileSizeBase().longValue());
            options.setCompressionType(CompressionType.valueOf((String)this.rocksDBConfig.getCompressionType()));
            options.setBottommostCompressionType(CompressionType.valueOf((String)this.rocksDBConfig.getBottommostCompressionType()));
            File dir = new File(this.rocksDBConfig.getPath());
            if (!dir.exists()) {
                dir.mkdirs();
            }
            this.db = RocksDB.open((Options)options, (String)this.rocksDBConfig.getPath());
        }
        catch (Exception e) {
            throw new RuntimeException("\u6253\u5f00 RocksDB \u5931\u8d25\uff01", e);
        }
    }

    public void put(String wcspText, String sm4Text) {
        if (StrUtil.isBlank((CharSequence)wcspText) || StrUtil.isBlank((CharSequence)sm4Text)) {
            throw new IllegalArgumentException("\u952e/\u503c\u4e0d\u53ef\u4e3a\u7a7a\uff01");
        }
        try {
            this.db.put(wcspText.getBytes(StandardCharsets.UTF_8), sm4Text.getBytes(StandardCharsets.UTF_8));
        }
        catch (RocksDBException e) {
            throw new RuntimeException("\u5c06\u6570\u636e\u653e\u5165 RocksDB \u5931\u8d25\uff01", e);
        }
    }

    public String get(String wcspText) {
        try {
            byte[] key = wcspText.getBytes(StandardCharsets.UTF_8);
            byte[] value = this.db.get(key);
            if (value == null) {
                String plainText = SpringEncryptUtils.decrypt((String)wcspText);
                this.put(wcspText, plainText);
                return plainText;
            }
            return new String(value, StandardCharsets.UTF_8);
        }
        catch (RocksDBException e) {
            throw new RuntimeException("\u4ece RocksDB \u83b7\u53d6\u6570\u636e\u5931\u8d25\uff01", e);
        }
    }

    public String getDb(String wcspText) {
        try {
            byte[] key = wcspText.getBytes(StandardCharsets.UTF_8);
            byte[] value = this.db.get(key);
            if (value == null) {
                return null;
            }
            return new String(value, StandardCharsets.UTF_8);
        }
        catch (RocksDBException e) {
            throw new RuntimeException("\u4ece RocksDB \u83b7\u53d6\u6570\u636e\u5931\u8d25\uff01", e);
        }
    }

    public Map<String, String> get(Collection<String> wcspTextTexts) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (String cipherText : wcspTextTexts) {
            result.put(cipherText, this.get(cipherText));
        }
        return result;
    }

    public long size() {
        try {
            return this.db.getLongProperty("rocksdb.estimate-num-keys");
        }
        catch (RocksDBException e) {
            log.error("\u83b7\u53d6\u6570\u636e\u5e93\u5927\u5c0f\u5931\u8d25", (Throwable)e);
            return -1L;
        }
    }

    @PreDestroy
    public void shutdown() {
        if (this.db != null) {
            this.db.close();
        }
    }

    public void compact() {
        try {
            this.db.compactRange();
        }
        catch (RocksDBException e) {
            throw new RuntimeException("\u538b\u7f29 RocksDB \u5931\u8d25\uff01", e);
        }
    }
}

