/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.services.encryptcache.storage;

import cn.hutool.core.map.MapUtil;
import cn.smarthse.encrypt.spring.utils.SpringEncryptUtils;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.stats.CacheStats;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CaffeineEncryptCache {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CaffeineEncryptCache.class);
    Cache<String, String> cache = Caffeine.newBuilder().build();

    public void put(String cipherText, String plainText) {
        this.cache.put((Object)cipherText, (Object)plainText);
    }

    public long size() {
        return this.cache.estimatedSize();
    }

    public void clear() {
        this.cache.invalidateAll();
    }

    public String stats() {
        CacheStats stats = this.cache.stats();
        return stats.toString();
    }

    public String get(String cipherText) {
        try {
            String compressed = (String)this.cache.get((Object)cipherText, key -> {
                String plainText = SpringEncryptUtils.decrypt((String)key);
                return plainText;
            });
            return compressed;
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u7f13\u5b58\u5931\u8d25", (Throwable)e);
            return null;
        }
    }

    public Map<String, String> get(Collection<String> cipherTexts) {
        if (CollectionUtils.isEmpty(cipherTexts)) {
            return Collections.emptyMap();
        }
        HashMap resultMap = MapUtil.newHashMap((int)cipherTexts.size());
        for (String cipherText : cipherTexts) {
            resultMap.put(cipherText, this.get(cipherText));
        }
        return resultMap;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private byte[] compress(byte[] data) {
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            byte[] byArray;
            try (DeflaterOutputStream deflaterOut = new DeflaterOutputStream((OutputStream)out, new Deflater(9));){
                deflaterOut.write(data);
                deflaterOut.finish();
                byArray = out.toByteArray();
            }
            return byArray;
        }
        catch (IOException e) {
            throw new RuntimeException("\u538b\u7f29\u5931\u8d25", e);
        }
    }

    /*
     * Exception decompiling
     */
    private byte[] decompress(byte[] data) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

