/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.services.encryptcache.component;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.smarthse.encrypt.spring.utils.SpringEncryptUtils;
import cn.smarthse.encrypt.utils.EncryptUtils;
import cn.smarthse.es.esservice.IOrigiCipIdEsService;
import cn.smarthse.es.model.OrigiCipIdModel;
import cn.smarthse.es.model.OrigiCipIdParamModel;
import cn.smarthse.modules.common.cache.IEncryptCacheService;
import cn.smarthse.services.encryptcache.storage.RocksDBEncryptCache;
import com.github.pagehelper.PageInfo;
import com.xxl.job.core.context.XxlJobHelper;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@DubboService
@Service
public class EncryptCacheServiceImpl
implements IEncryptCacheService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EncryptCacheServiceImpl.class);
    private final RocksDBEncryptCache rocksDBEncryptCache;
    @Value(value="${mybatis-encryptor.groupConfigs[0].password}")
    private String password;
    @DubboReference
    private IOrigiCipIdEsService origiCipIdEsService;

    @Autowired
    public EncryptCacheServiceImpl(RocksDBEncryptCache rocksDBEncryptCache) {
        this.rocksDBEncryptCache = rocksDBEncryptCache;
    }

    public String get(String wcspText) {
        return this.rocksDBEncryptCache.get(wcspText);
    }

    public String decrypt(String wcspText, Boolean showLog) {
        String esPlaintextSM4;
        if (CharSequenceUtil.isBlank((CharSequence)wcspText)) {
            return null;
        }
        String dbPlaintextSM4 = this.rocksDBEncryptCache.getDb(wcspText);
        if (CharSequenceUtil.isNotBlank((CharSequence)dbPlaintextSM4)) {
            if (Boolean.TRUE.equals(showLog)) {
                XxlJobHelper.log((String)"\u65e5\u5fd7\u6253\u5370::\u547d\u4e2dRocksDB::\u89e3\u5bc6\u6210\u529f::[ {} -> {} ]", (Object[])new Object[]{wcspText, dbPlaintextSM4});
                log.error("\u65e5\u5fd7\u6253\u5370::\u547d\u4e2dRocksDB::\u89e3\u5bc6\u6210\u529f::[ {} -> {} ]", (Object)wcspText, (Object)dbPlaintextSM4);
            }
            return dbPlaintextSM4;
        }
        OrigiCipIdParamModel esParam = new OrigiCipIdParamModel();
        esParam.setCipDatas((List)ListUtil.toList((Object[])new String[]{wcspText}));
        PageInfo esPage = this.origiCipIdEsService.pageByCiphertextList(esParam, 1, 1, Boolean.FALSE);
        List esList = esPage.getList();
        String string = esPlaintextSM4 = CollUtil.isEmpty((Collection)esList) ? null : ((OrigiCipIdModel)esList.get(0)).getOrgiData();
        if (CharSequenceUtil.isNotBlank(esPlaintextSM4)) {
            if (Boolean.TRUE.equals(showLog)) {
                XxlJobHelper.log((String)"\u65e5\u5fd7\u6253\u5370::\u547d\u4e2dES::\u89e3\u5bc6\u6210\u529f::[ {} -> {} ]", (Object[])new Object[]{wcspText, esPlaintextSM4});
                log.error("\u65e5\u5fd7\u6253\u5370::\u547d\u4e2dES::\u89e3\u5bc6\u6210\u529f::[ {} -> {} ]", (Object)wcspText, (Object)esPlaintextSM4);
            }
            return esPlaintextSM4;
        }
        String sdkPlaintext = SpringEncryptUtils.decrypt((String)wcspText);
        String sdkPlaintextSM4 = this.encryptLocalSm4(sdkPlaintext);
        if (Boolean.TRUE.equals(showLog)) {
            XxlJobHelper.log((String)"\u65e5\u5fd7\u6253\u5370::\u547d\u4e2dSDK::\u89e3\u5bc6\u6210\u529f::[ {} -> {} ]", (Object[])new Object[]{wcspText, sdkPlaintextSM4});
            log.error("\u65e5\u5fd7\u6253\u5370::\u547d\u4e2dSDK::\u89e3\u5bc6\u6210\u529f::[ {} -> {} ]", (Object)wcspText, (Object)sdkPlaintextSM4);
        }
        return sdkPlaintextSM4;
    }

    public String encrypt(String plaintextSM4, Boolean showLog) {
        OrigiCipIdParamModel esParam = new OrigiCipIdParamModel();
        esParam.setOrgiDatas((List)ListUtil.toList((Object[])new String[]{plaintextSM4}));
        PageInfo esPage = this.origiCipIdEsService.pageByPlaintextList_base(esParam, 1, 1, Boolean.FALSE, Boolean.FALSE);
        List esList = esPage.getList();
        return CollUtil.isEmpty((Collection)esList) ? null : ((OrigiCipIdModel)esList.get(0)).getCipData();
    }

    public Map<String, String> get(Collection<String> wcspTextTexts) {
        return this.rocksDBEncryptCache.get(wcspTextTexts);
    }

    public Map<String, String> decrypt(Collection<String> wcspTexts) {
        HashMap<String, String> plaintextMap = new HashMap<String, String>();
        for (String wcspText : wcspTexts) {
            plaintextMap.put(wcspText, this.decrypt(wcspText, Boolean.FALSE));
        }
        return plaintextMap;
    }

    public void put(String wcspText, String sm4Text) {
        this.rocksDBEncryptCache.put(wcspText, sm4Text);
    }

    public long size() {
        return this.rocksDBEncryptCache.size();
    }

    public void fill(String plaintextSM4, String ciphertext) {
        this.put(ciphertext, plaintextSM4);
        OrigiCipIdModel model = new OrigiCipIdModel();
        model.setOrgiData(plaintextSM4);
        model.setCipData(ciphertext);
        this.origiCipIdEsService.save(model);
    }

    private String encryptLocalSm4(String plaintext) {
        if (CharSequenceUtil.isBlank((CharSequence)plaintext)) {
            return null;
        }
        try {
            return EncryptUtils.encryptBySm4((String)plaintext, (String)this.password);
        }
        catch (Exception e) {
            return null;
        }
    }

    private String decryptLocalSm4(String ciphertext) {
        if (CharSequenceUtil.isBlank((CharSequence)ciphertext)) {
            return null;
        }
        try {
            return EncryptUtils.decryptBySm4((String)ciphertext, (String)this.password);
        }
        catch (Exception e) {
            return null;
        }
    }
}

