/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.framework.encrypt.interceptor;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.smarthse.encrypt.spring.properties.FieldEncryptorProperties;
import cn.smarthse.framework.encrypt.annotation.EncryptField;
import cn.smarthse.framework.encrypt.core.EncryptContext;
import cn.smarthse.framework.encrypt.core.EncryptorManager;
import cn.smarthse.framework.encrypt.enumd.AlgorithmType;
import cn.smarthse.framework.encrypt.enumd.DataProcessingMethodsType;
import com.baomidou.mybatisplus.core.MybatisParameterHandler;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.apache.ibatis.executor.parameter.ParameterHandler;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.scripting.defaults.DefaultParameterHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Intercepts(value={@Signature(type=ParameterHandler.class, method="setParameters", args={PreparedStatement.class})})
public class MybatisEncryptInterceptor
implements Interceptor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MybatisEncryptInterceptor.class);
    private final EncryptorManager encryptorManager;
    private final FieldEncryptorProperties fieldEncryptionProperties;
    private static final Field BOUND_SQL_FIELD;
    private static Field META_PARAMETERS_FIELD;
    private static Field ORIGINAL_OBJECT_FIELD;
    private static final Map<Class<?>, List<Field>> FIELD_CACHE;
    private static final Map<Field, DataProcessingMethodsType> FIELD_ANNOTATION_CACHE;
    private volatile AlgorithmType cachedAlgorithmType;
    private volatile boolean cachedMiddlewareEnabled;
    private volatile FieldEncryptorProperties.GroupConfig cachedGroupConfig;

    public MybatisEncryptInterceptor(EncryptorManager encryptorManager, FieldEncryptorProperties fieldEncryptionProperties) {
        this.encryptorManager = encryptorManager;
        this.fieldEncryptionProperties = fieldEncryptionProperties;
    }

    public Object intercept(Invocation invocation) {
        return invocation;
    }

    public Object plugin(Object target) {
        ParameterHandler parameterHandler;
        Object parameterObject;
        if (target instanceof ParameterHandler && ObjectUtil.isNotNull((Object)(parameterObject = (parameterHandler = (ParameterHandler)target).getParameterObject())) && !(parameterObject instanceof String)) {
            HashMap<Object, Object> copyParameterObject = null;
            if (parameterObject instanceof Map && parameterHandler instanceof MybatisParameterHandler) {
                copyParameterObject = new HashMap<Object, Object>((Map)parameterObject);
                MybatisParameterHandler mybatisParameterHandler = (MybatisParameterHandler)target;
                parameterObject = this.getMybatisParameterHandlerOriginalParameter(mybatisParameterHandler);
            }
            this.encryptHandler(parameterObject);
            if (ObjectUtil.isNotNull(copyParameterObject) && !Objects.equals(copyParameterObject, parameterObject)) {
                Map<String, Object> afterMap = this.getFieldAndValueMap(parameterObject);
                HashMap<String, Object> beforeMap = new HashMap<String, Object>(copyParameterObject.size() + afterMap.size());
                copyParameterObject.forEach((key, value) -> beforeMap.put(key.toString(), value));
                beforeMap.putAll(afterMap);
                try {
                    Field parameterObjectField = DefaultParameterHandler.class.getDeclaredField("parameterObject");
                    parameterObjectField.setAccessible(true);
                    parameterObjectField.set(target, beforeMap);
                }
                catch (Exception e) {
                    log.error("[Encrypt] [\u53c2\u6570\u8986\u76d6\u5f02\u5e38] [failure] [error] [unknown] errorMsg={} exceptionClass={}", new Object[]{e.getMessage(), e.getClass().getSimpleName(), e});
                }
            }
        }
        return target;
    }

    private Map<String, Object> getFieldAndValueMap(Object obj) {
        if (ObjectUtil.isNull((Object)obj)) {
            return MapUtil.newHashMap();
        }
        Class<?> clazz = obj.getClass();
        List fields = FIELD_CACHE.computeIfAbsent(clazz, c -> {
            if (c.getName().startsWith("java.") || c.getName().startsWith("javax.")) {
                return CollUtil.newArrayList((Object[])new Field[0]);
            }
            ArrayList<Field> fieldList = new ArrayList<Field>();
            for (Class currentClass = c; ObjectUtil.isNotNull((Object)currentClass) && currentClass != Object.class; currentClass = currentClass.getSuperclass()) {
                Field[] declaredFields;
                for (Field field : declaredFields = currentClass.getDeclaredFields()) {
                    if (field.getDeclaringClass().getName().startsWith("java.") || field.getDeclaringClass().getName().startsWith("javax.")) continue;
                    field.setAccessible(true);
                    fieldList.add(field);
                }
            }
            return fieldList;
        });
        HashMap<String, Object> fieldMap = new HashMap<String, Object>();
        for (Field field : fields) {
            try {
                fieldMap.put(field.getName(), field.get(obj));
            }
            catch (IllegalAccessException e) {
                log.error("[Encrypt] [\u5b57\u6bb5\u8bbf\u95ee\u5f02\u5e38] [failure] [error] [unknown] fieldName={} errorMsg={} exceptionClass={}", new Object[]{field.getName(), e.getMessage(), e.getClass().getSimpleName(), e});
            }
        }
        return fieldMap;
    }

    private Object getMybatisParameterHandlerOriginalParameter(MybatisParameterHandler parameterHandler) {
        try {
            Object originalObject;
            Object boundSql = BOUND_SQL_FIELD.get(parameterHandler);
            if (ObjectUtil.isNull((Object)META_PARAMETERS_FIELD)) {
                Field metaParametersField = boundSql.getClass().getDeclaredField("metaParameters");
                metaParametersField.setAccessible(true);
                META_PARAMETERS_FIELD = metaParametersField;
            }
            Object metaParameters = META_PARAMETERS_FIELD.get(boundSql);
            if (ObjectUtil.isNull((Object)ORIGINAL_OBJECT_FIELD)) {
                Field originalObjectField = metaParameters.getClass().getDeclaredField("originalObject");
                originalObjectField.setAccessible(true);
                ORIGINAL_OBJECT_FIELD = originalObjectField;
            }
            if ((originalObject = ORIGINAL_OBJECT_FIELD.get(metaParameters)) instanceof Map) {
                Map map = (Map)originalObject;
                Object obj = map.get("_parameter");
                return ObjectUtil.isNull(obj) ? parameterHandler.getParameterObject() : obj;
            }
        }
        catch (Exception e) {
            log.error("[Encrypt] [\u53c2\u6570\u63d0\u53d6\u5f02\u5e38] [failure] [error] [unknown] errorMsg={} exceptionClass={}", new Object[]{e.getMessage(), e.getClass().getSimpleName(), e});
        }
        return null;
    }

    private void encryptHandler(Object sourceObject) {
        if (ObjectUtil.isNull((Object)sourceObject)) {
            return;
        }
        if (sourceObject instanceof Map) {
            Map map = (Map)sourceObject;
            new HashSet(map.values()).forEach(this::encryptHandler);
            return;
        }
        if (sourceObject instanceof List) {
            List list = (List)sourceObject;
            if (CollUtil.isEmpty((Collection)list)) {
                return;
            }
            Object firstItem = list.get(0);
            if (ObjectUtil.isNull(firstItem) || CollUtil.isEmpty(this.encryptorManager.getFieldCache(firstItem.getClass()))) {
                return;
            }
            list.forEach(this::encryptHandler);
            return;
        }
        Set<Field> fields = this.encryptorManager.getFieldCache(sourceObject.getClass());
        if (ObjectUtil.isNull(fields)) {
            return;
        }
        for (Field field : fields) {
            try {
                String originalValue = Convert.toStr((Object)field.get(sourceObject));
                String encryptedValue = this.encryptField(originalValue, field);
                field.set(sourceObject, encryptedValue);
            }
            catch (Exception e) {
                log.error("[Encrypt] [\u52a0\u5bc6\u5b57\u6bb5\u5f02\u5e38] [failure] [error] [unknown] fieldName={} errorMsg={} exceptionClass={}", new Object[]{field.getName(), e.getMessage(), e.getClass().getSimpleName(), e});
                throw new RuntimeException("\u5904\u7406\u52a0\u5bc6\u5b57\u6bb5\u65f6\u51fa\u9519", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String encryptField(String value, Field field) {
        byte[] data;
        if (StrUtil.isBlank((CharSequence)value)) {
            return value;
        }
        if (StrUtil.startWith((CharSequence)(value = StrUtil.trim((CharSequence)value)), (CharSequence)"VI*D#S")) {
            log.warn("[Encrypt] [\u91cd\u590d\u52a0\u5bc6\u8b66\u544a] [warning] [warning] [unknown] fieldName={} originalValue={} message=\u6570\u636e\u5df2\u52a0\u5bc6\uff0c\u8bf7\u52ff\u91cd\u590d\u52a0\u5bc6", (Object)field.getName(), (Object)value);
            return value;
        }
        if (ObjectUtil.isNull((Object)((Object)this.cachedAlgorithmType))) {
            MybatisEncryptInterceptor mybatisEncryptInterceptor = this;
            synchronized (mybatisEncryptInterceptor) {
                if (ObjectUtil.isNull((Object)((Object)this.cachedAlgorithmType))) {
                    this.cachedAlgorithmType = AlgorithmType.getByName(this.fieldEncryptionProperties.getAlgorithm());
                    this.cachedMiddlewareEnabled = this.fieldEncryptionProperties.getMiddlewareEnabled();
                    this.cachedGroupConfig = this.fieldEncryptionProperties.getMaxVersionGroupConfig();
                }
            }
        }
        if (AlgorithmType.WCSP_LIGHT_DATA_SERVICE.equals((Object)this.cachedAlgorithmType) && (data = value.getBytes(StandardCharsets.UTF_8)).length > 1023) {
            throw new IllegalArgumentException(String.format("Input data is too long for algorithm %s. Max length: 1023, Actual length: %d, Field: %s", this.cachedAlgorithmType.getName(), data.length, field.getName()));
        }
        EncryptContext encryptContext = new EncryptContext();
        encryptContext.setMiddlewareEnabled(this.cachedMiddlewareEnabled);
        encryptContext.setAlgorithm(this.cachedAlgorithmType);
        DataProcessingMethodsType processingType = FIELD_ANNOTATION_CACHE.computeIfAbsent(field, f -> {
            EncryptField encryptField = f.getAnnotation(EncryptField.class);
            return ObjectUtil.isNotNull((Object)encryptField) && ObjectUtil.isNotNull((Object)((Object)encryptField.dataProcessingMethodsType())) ? encryptField.dataProcessingMethodsType() : DataProcessingMethodsType.ACCURATE;
        });
        encryptContext.setDataProcessingMethodsType(processingType);
        encryptContext.setVersion(this.cachedGroupConfig.getVersion());
        encryptContext.setPassword(this.cachedGroupConfig.getPassword());
        encryptContext.setPublicKey(this.cachedGroupConfig.getPublicKey());
        encryptContext.setPrivateKey(this.cachedGroupConfig.getPrivateKey());
        return this.encryptorManager.encrypt(value, encryptContext);
    }

    public void setProperties(Properties properties) {
    }

    static {
        FIELD_CACHE = new ConcurrentHashMap();
        FIELD_ANNOTATION_CACHE = new ConcurrentHashMap<Field, DataProcessingMethodsType>();
        try {
            BOUND_SQL_FIELD = MybatisParameterHandler.class.getSuperclass().getDeclaredField("boundSql");
            BOUND_SQL_FIELD.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

