/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.framework.encrypt.core.encryptor;

import cn.smarthse.encrypt.utils.EncryptUtils;
import cn.smarthse.framework.encrypt.core.EncryptContext;
import cn.smarthse.framework.encrypt.core.encryptor.AbstractEncryptor;
import cn.smarthse.framework.encrypt.enumd.AlgorithmType;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WcspLightDataServiceEncryptor
extends AbstractEncryptor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WcspLightDataServiceEncryptor.class);
    private final EncryptContext context;

    public WcspLightDataServiceEncryptor(EncryptContext context) {
        super(context);
        this.context = context;
    }

    @Override
    public AlgorithmType algorithm() {
        return AlgorithmType.WCSP_LIGHT_DATA_SERVICE;
    }

    @Override
    public String encrypt(String value) {
        for (int retryCount = 0; retryCount < 3; ++retryCount) {
            try {
                return EncryptUtils.encryptByWcspLightDataService((String)value);
            }
            catch (Exception e) {
                if (retryCount != 2) continue;
                log.error("\u52a0\u5bc6\u64cd\u4f5c\u91cd\u8bd5{}\u6b21\u540e\u4ecd\u5931\u8d25", (Object)3, (Object)e);
                throw new RuntimeException("\u52a0\u5bc6\u64cd\u4f5c\u91cd\u8bd53\u6b21\u540e\u4ecd\u5931\u8d25", e);
            }
        }
        return null;
    }

    @Override
    public String decrypt(String value) {
        for (int retryCount = 0; retryCount < 3; ++retryCount) {
            try {
                return EncryptUtils.decryptByWcspLightDataService((String)value);
            }
            catch (Exception e) {
                if (retryCount != 2) continue;
                log.error("\u89e3\u5bc6\u64cd\u4f5c\u91cd\u8bd5{}\u6b21\u540e\u4ecd\u5931\u8d25", (Object)3, (Object)e);
                throw new RuntimeException("\u89e3\u5bc6\u64cd\u4f5c\u91cd\u8bd53\u6b21\u540e\u4ecd\u5931\u8d25", e);
            }
        }
        return null;
    }
}

