/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.framework.encrypt.config;

import cn.smarthse.encrypt.context.WcspEncryptContext;
import cn.smarthse.encrypt.pool.WcspCryptoServicePlatformPool;
import cn.smarthse.encrypt.spring.properties.FieldEncryptorProperties;
import cn.smarthse.encrypt.utils.EncryptUtils;
import cn.smarthse.framework.encrypt.core.EncryptorManager;
import cn.smarthse.framework.encrypt.interceptor.MybatisDecryptInterceptor;
import cn.smarthse.framework.encrypt.interceptor.MybatisEncryptInterceptor;
import java.util.concurrent.ScheduledExecutorService;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@AutoConfiguration
@EnableConfigurationProperties(value={FieldEncryptorProperties.class})
public class FieldEncryptorAutoConfig {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FieldEncryptorAutoConfig.class);
    private final FieldEncryptorProperties fieldEncryptionProperties;
    private final ScheduledExecutorService scheduledExecutorService;

    @Bean
    @ConditionalOnProperty(value={"mybatis-encryptor.enabled"}, havingValue="true")
    public EncryptorManager encryptorManager() {
        log.info("\u521d\u59cb\u5316 EncryptorManager \u914d\u7f6e");
        return new EncryptorManager(this.fieldEncryptionProperties.getTypeAliasesPackage(), this.scheduledExecutorService);
    }

    @Bean(destroyMethod="close")
    @ConditionalOnBean(value={EncryptorManager.class})
    @ConditionalOnProperty(value={"mybatis-encryptor.algorithm"}, havingValue="WCSP_LIGHT_DATA_SERVICE")
    @ConditionalOnClass(name={"cn.com.westone.wcspsdk.CryptoServicePlatform"})
    public WcspCryptoServicePlatformPool wcspCryptoServicePlatformPool() {
        log.info("\u521d\u59cb\u5316 WcspEncryptUtils \u914d\u7f6e");
        WcspEncryptContext context = new WcspEncryptContext();
        context.setUrl(this.fieldEncryptionProperties.getWcspUrl());
        context.setTenantId(this.fieldEncryptionProperties.getWcspTenantId());
        context.setAppId(this.fieldEncryptionProperties.getWcspAppId());
        context.setSecret(this.fieldEncryptionProperties.getWcspSecret());
        context.setWorkDir(this.fieldEncryptionProperties.getWcspWorkDir());
        context.setPoolMaxTotal(this.fieldEncryptionProperties.getWcspPoolMaxTotal());
        context.setPoolMaxIdle(this.fieldEncryptionProperties.getWcspPoolMaxIdle());
        context.setPoolMinIdle(this.fieldEncryptionProperties.getWcspPoolMinIdle());
        context.setPoolMaxWaitMillis(this.fieldEncryptionProperties.getWcspPoolMaxWaitMillis());
        context.setVersion(this.fieldEncryptionProperties.getWcspVersion());
        context.setKeyId(this.fieldEncryptionProperties.getWcspKeyId());
        WcspCryptoServicePlatformPool pool = new WcspCryptoServicePlatformPool(context);
        EncryptUtils.wcspInitialize((WcspCryptoServicePlatformPool)pool);
        return pool;
    }

    @Bean
    @ConditionalOnProperty(value={"mybatis-encryptor.enabled"}, havingValue="true")
    public MybatisEncryptInterceptor mybatisEncryptInterceptor(EncryptorManager encryptorManager) {
        log.info("\u521d\u59cb\u5316 MybatisEncryptInterceptor \u914d\u7f6e");
        return new MybatisEncryptInterceptor(encryptorManager, this.fieldEncryptionProperties);
    }

    @Bean
    @ConditionalOnProperty(value={"mybatis-encryptor.enabled"}, havingValue="true")
    public MybatisDecryptInterceptor mybatisDecryptInterceptor(EncryptorManager encryptorManager) {
        log.info("\u521d\u59cb\u5316 MybatisDecryptInterceptor \u914d\u7f6e");
        return new MybatisDecryptInterceptor(encryptorManager, this.fieldEncryptionProperties);
    }

    @Generated
    public FieldEncryptorAutoConfig(FieldEncryptorProperties fieldEncryptionProperties, ScheduledExecutorService scheduledExecutorService) {
        this.fieldEncryptionProperties = fieldEncryptionProperties;
        this.scheduledExecutorService = scheduledExecutorService;
    }
}

