/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.services.train.api.enums;

import cn.smarthse.services.train.api.enums.TrainingExamTypeEnum;
import cn.smarthse.services.train.api.enums.question.TrainingApplyObjectEnum;
import com.fasterxml.jackson.annotation.JsonFormat;

@JsonFormat(shape=JsonFormat.Shape.OBJECT)
public enum TrainingExamRuleEnum {
    Training_Exam_Type_1("\u4e3b\u8981\u8d1f\u8d23\u4eba\u3001\u804c\u4e1a\u536b\u751f\u7ba1\u7406\u4eba\u5458\u7ebf\u4e0b\u8003\u8bd5", 1L, 1),
    Training_Exam_Type_2("\u4e3b\u8981\u8d1f\u8d23\u4eba\u3001\u804c\u4e1a\u536b\u751f\u7ba1\u7406\u4eba\u5458\u5728\u7ebf\u9884\u8003\u6838", 2L, 2),
    Training_Exam_Type_3("\u52b3\u52a8\u8005\u5728\u7ebf\u8003\u8bd5", 3L, 3);

    private String name;
    private Long id;
    private Integer type;

    private TrainingExamRuleEnum(String name, Long id, Integer type) {
        this.name = name;
        this.id = id;
        this.type = type;
    }

    public static TrainingExamRuleEnum getTrainingExamTypeEnum(Byte role, Integer examType) {
        TrainingExamTypeEnum examTypeEnum = TrainingExamTypeEnum.getByType(examType);
        return TrainingExamRuleEnum.getTrainingExamTypeEnum(role, examTypeEnum);
    }

    public static TrainingExamRuleEnum getTrainingExamTypeEnum(Byte role, String examType) {
        TrainingExamTypeEnum examTypeEnum = TrainingExamTypeEnum.getByValue(examType);
        return TrainingExamRuleEnum.getTrainingExamTypeEnum(role, examTypeEnum);
    }

    public static TrainingExamRuleEnum getTrainingExamTypeEnum(Byte role, TrainingExamTypeEnum examTypeEnum) {
        if (role == null || examTypeEnum == null) {
            return Training_Exam_Type_1;
        }
        if (role == TrainingApplyObjectEnum.LEADER.getValue()) {
            if (TrainingExamTypeEnum.Training_Exam_Type_1.equals((Object)examTypeEnum)) {
                return Training_Exam_Type_2;
            }
            if (TrainingExamTypeEnum.Training_Exam_Type_2.equals((Object)examTypeEnum)) {
                return Training_Exam_Type_1;
            }
            if (TrainingExamTypeEnum.Training_Exam_Type_3.equals((Object)examTypeEnum)) {
                return Training_Exam_Type_1;
            }
        } else if (role == TrainingApplyObjectEnum.MANAGER.getValue()) {
            if (TrainingExamTypeEnum.Training_Exam_Type_1.equals((Object)examTypeEnum)) {
                return Training_Exam_Type_2;
            }
            if (TrainingExamTypeEnum.Training_Exam_Type_2.equals((Object)examTypeEnum)) {
                return Training_Exam_Type_1;
            }
            if (TrainingExamTypeEnum.Training_Exam_Type_3.equals((Object)examTypeEnum)) {
                return Training_Exam_Type_1;
            }
        } else if (role == TrainingApplyObjectEnum.WORKER.getValue()) {
            if (TrainingExamTypeEnum.Training_Exam_Type_1.equals((Object)examTypeEnum)) {
                return Training_Exam_Type_3;
            }
            if (TrainingExamTypeEnum.Training_Exam_Type_2.equals((Object)examTypeEnum)) {
                return Training_Exam_Type_3;
            }
            if (TrainingExamTypeEnum.Training_Exam_Type_3.equals((Object)examTypeEnum)) {
                return Training_Exam_Type_3;
            }
        }
        return Training_Exam_Type_1;
    }

    public static String getName(Long id) {
        if (id == null) {
            return null;
        }
        for (TrainingExamRuleEnum c : TrainingExamRuleEnum.values()) {
            if (!c.getId().equals(id)) continue;
            return c.name;
        }
        return null;
    }

    public static String getName(Integer type) {
        if (type == null) {
            return null;
        }
        for (TrainingExamRuleEnum c : TrainingExamRuleEnum.values()) {
            if (!c.getType().equals(type)) continue;
            return c.name;
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Integer getType() {
        return this.type;
    }

    public void setType(Integer type) {
        this.type = type;
    }
}

