package cn.smarthse.services.train.api.vo.video;

import cn.smarthse.modules.datacentre.model.system.IndustryModel;
import cn.smarthse.modules.datacentre.model.system.riskFactors.HarmFactor;
import cn.smarthse.services.train.api.entity.video.TrainingVideo;
import cn.smarthse.services.train.api.entity.video.TrainingVideoObject;
import com.baomidou.mybatisplus.annotation.TableField;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

@Data
public class TrainingVideoVo extends TrainingVideo {

    @ApiModelProperty(value = "适用对象(界面展示)")
    private String objectNameStr;

    @ApiModelProperty(value = "适用对象(TrainingObject对象Ids:通过逗号隔开)")
    private String objectIdsStr;

    @TableField(exist = false)
    @ApiModelProperty(value = "适用对象(TrainingObject对象List)")
    private List<TrainingVideoObject> videoObjects;

    @ApiModelProperty(value = "视频时长(界面展示)")
    private String videoTimeStr;

    @ApiModelProperty(value = "状态")
    private String stateStr;

    @ApiModelProperty(value = "危害因素名称(通过逗号隔开)")
    private String riskNameStr;

    @ApiModelProperty(value = "危害因素ids(通过逗号隔开)")
    private String riskIdsStr;

    @ApiModelProperty(value = "行业名称(通过逗号隔开)")
    private String industryNameStr;

    @ApiModelProperty(value = "行业ids(通过逗号隔开)")
    private String industryIdsStr;

    @ApiModelProperty(value = "上架时间格式化")
    private String onShelvesTimeStr;

    @ApiModelProperty(value = "下架时间格式化")
    private String offShelvesTimeStr;


    @ApiModelProperty(value = "编制人")
    private String updateName;


    @TableField(exist = false)
    @ApiModelProperty(value = "危害因素List")
    private List<HarmFactor> harmFactors;

    @TableField(exist = false)
    @ApiModelProperty(value = "行业List")
    private List<IndustryModel> industryModels;


}
