package cn.smarthse.services.train.api.vo.challenganswer;


import cn.smarthse.services.train.api.model.challenganswer.ExamModel;
import cn.smarthse.services.train.api.model.challenganswer.ExamQuestionModel;
import cn.smarthse.services.train.api.model.challenganswer.UserExamModel;
import cn.smarthse.services.train.api.model.challenganswer.UserExamQuestionModel;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * 用户-专项答题/每周答题详情
 * @Description 
 * @Author xiaoyi
 * @Date 2022年5月27日 下午1:41:52
 */
public @Data class UserExamVo implements Serializable {
	
	private static final long serialVersionUID = 1L;
	
	/**
	 * 试题对象
	 */
	private ExamModel examModel;
	
	private List<ExamQuestionModel> examQuestionModelList;
	
	/**
	 * 用户-试题关系表
	 */
	private UserExamModel userExamModel;
	
	/**
	 * 答题详情
	 */
	private List<UserExamQuestionModel> userExamQuestionModelList;
	
	/**
	 * 当日每周/专项答题积分是否上限(true：上限；false：没上限)
	 */
	private Boolean isMaxIntegral;
}
