package cn.smarthse.services.train.api.vo;

import lombok.Data;

import java.io.Serializable;
import java.util.Set;

/**
 * @author 邓力宾
 * @date 2021/1/27 14:56
 * @desc 监管端 培训结果统计 vo
 */
@Data
public class TrainResultStatVo implements Serializable {
    private Long areaId;//行政区域id
    private String areaName;//行政区域名称

    private Integer totalComNum = 0;//企业总数 （当前行政区域）
    private Set<Long> totalCids; //企业id

    private Integer trainComNum = 0; //参与培训的企业总数
    private Set<Long> trainCids; //企业id

    private String  trainComRate;//企业参与培训率

    private Integer trainPrincipalNum = 0; //主要负责人培训人数
    private Set<Long> trainPrincipalStaffIds; //主要负责人培训人id

    private Integer trainManagerNum = 0; //管理人员培训人数
    private Set<Long> trainManagerStaffIds; //管理人员培训人 id

    private Integer trainWorkerNum = 0;//劳动者培训人数
    private Set<Long> trainWorkerStaffIds; //劳动者培训人 id

    private Integer trainTotalNum = 0;//培训总人数
    private Set<Long> trainTotalStaffIds; //培训人员 id

    private Integer examNum = 0;//考试人数
    private Set<Long> examStaffIds; //考试人员 id

    private Integer examPassNum = 0;//考试合格人数
    private Set<Long> examPassStaffIds; //考试合格人员id

    private Integer examPassRate;//考试合格率


    //企业参与培训率
    public String getTrainComRate() {

        if(!totalComNum.equals(0)){
            return (trainComNum) * 100 / totalComNum +"%";
        }
        return "0%";
    }
    //考试合格率
    public String getExamPassRate() {

        if(!examNum.equals(0)){
            return (examPassNum) * 100 / examNum +"%";
        }
        return "0%";
    }



}
