package cn.smarthse.services.train.api.service.video;

import cn.smarthse.common.framework.jqgrid.JqGridData;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.db.common.service.IBaseService;
import cn.smarthse.services.train.api.entity.video.TrainingVideo;
import cn.smarthse.services.train.api.model.video.TrainingVideoModel;
import cn.smarthse.services.train.api.model.video.VideoModel;
import cn.smarthse.services.train.api.vo.video.TrainingVideoSearchParam;
import cn.smarthse.services.train.api.vo.video.TrainingVideoVo;
import com.github.pagehelper.PageInfo;

import java.util.List;

/**
 * <p>
 * 培训视频 服务类
 * </p>
 *
 * @author xubin
 * @since 2021-01-25
 */
public interface ITrainingVideoService extends IBaseService<TrainingVideo> {

    PageInfo<TrainingVideoVo> getTrainingVideoVosPageBySearchParam(JqGridParam jparam, TrainingVideoSearchParam param);

    List<TrainingVideoVo > getTrainingVideoVosBySearchParam(TrainingVideoSearchParam param);

    TrainingVideo getNotValidTrainingVideo(Long areaId, Long userId);


	List<TrainingVideo> getVideoListByIds(String ids);

    void saveTrainingVideoSubmit(TrainingVideoVo vo);
    TrainingVideoVo getTrainingVideoVoId(Long id);

    void deleteTrainingVideoById(Long id, Long userId);

    void onOrOffShelvesVideoById(Long id,Integer state, Long userId);

	/**
	 * mobile端-线下考试-培训课程学习：查询培训用户的培训课程列表
	 * @author liaoly
	 * @date 2021年2月1日 上午10:10:03
	 * @param areaId : 区域id(trainingMember.areaId)
	 * @param level : 区域level(省：1，市：2，区：3)
	 * @param requireHour : 要求培训学时
	 * @param applyObject : 培训用户角色（1-主要负责人 2-职业卫生管理人员 3-劳动者）即：training_member.role可传入TrainingApplyObjectEnum.code
	 * @param riskIdList : 培训用户企业的 危害因素id集合
	 * @param industryIdList : 培训用户企业的 行业id集合
	 * @return List<TrainingVideoModel>
	 */
	List<TrainingVideoModel> getTrainingVideoModelList(Long areaId, int level, double requireHour, Byte applyObject, List<Long> riskIdList, List<Long> industryIdList);

    /* 从平台移过来的接口*/
    JqGridData<VideoModel> getAppList(JqGridParam param);

    VideoModel updateVideo(Long id, Long uid);

    List<VideoModel> getRandListByNum(int num);

    void collect(Long id, Long uid);

    void uncollect(Long id, Long uid);
}
