package cn.smarthse.services.train.api.service.video;

import cn.smarthse.db.common.service.IBaseService;
import cn.smarthse.modules.health.model.HTrainingVideoModel;
import cn.smarthse.services.train.api.entity.video.TrainingVideoMember;
import cn.smarthse.services.train.api.model.video.TrainingVideoMemberDetailModel;
import cn.smarthse.services.train.api.model.video.TrainingVideoMemberModel;

import java.util.List;

/**
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.8> 
 * @since 2021-01-27 04:11
 */
public interface ITrainingVideoMemberService extends IBaseService<TrainingVideoMember> {

    /**
     * @Description  根据 用户id 查询视频课程学习情况列表(没有数据会根据规则创建)
     * @Author Wuxq
     * @Date 16:47 2021/1/27
     * @Param [memberId]
     * @return
     **/
    List<TrainingVideoMemberModel> getTrainingVideoMemberListByMemberId(Long memberId);

    /**
     * @Description  查询用户视频课程学习情况详情
     * @Author Wuxq
     * @Date 8:42 2021/1/29
     * @Param [TrainingVideoMember.Id]
     * @return cn.smarthse.modules.eduTraining.model.TrainingVideoMemberDetailModel
     **/
    TrainingVideoMemberDetailModel getTrainingVideoMemberDetailModel(Long id);

     /**
      *@ Description: <添加培训视频学习记录>
      *@ Author XiaoYi
      *@ Date  2022/1/25  11:14
      *@ param
      *@ return
     **/
    void addVideoLearningRecord(Long trainId,String videoIds,String memberIds);

    /**
     *@ Description: <更改视频状态接口>
     *@ Author Xubin
     *@ Date  2022/1/25  11:14
     *@ param videoId 视频id
     *@ param trainId 培训id
     *@ param staffId 人员id
     *@ param status  视频学习状态(0,未学习; 1,学习中; 2,已学习)
     *@ return
     **/
    void updateVideoStat(Long videoId,Long trainId,Long staffId,Byte status);

     /**
      *@ Description: <获取人员培训状态>
      *@ Author XiaoYi
      *@ Date  2022/2/9  8:55
      *@ param
      *@ return 0，无需培训，1未培训，2培训中，3已培训
     **/
    Integer getTrainStateByStaffId(Long staffId,Long trainId);
 /**
  *@ Description: <获取学习进度>
  *@ Author XiaoYi
  *@ Date  2022/2/10  10:06
  *@ param
  *@ return
 **/
    String getTrainRateByStaffId(Long staffId,Long trainId);

 /**
  *@ Description: <获取培训学习视频列表>
  *@ Author XiaoYi
  *@ Date  2022/2/10  10:14
  *@ param
  *@ return
 **/
    List<HTrainingVideoModel> getTrainingVideoLearnInfoByStaffAndTrain(Long staffId, Long trainId);
}
