package cn.smarthse.services.train.api.service.question;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.db.common.service.IBaseService;
import cn.smarthse.modules.eduTraining.model.EduTrainingExamQuestionModel;
import cn.smarthse.modules.eduTraining.model.EduTrainingQuestionParam;
import cn.smarthse.services.train.api.entity.question.TrainingQuestion;
import cn.smarthse.services.train.api.model.challenganswer.QuestionWithAnswerModel;
import cn.smarthse.services.train.api.model.exam.ExamQuestionTypeModel;
import cn.smarthse.services.train.api.model.question.QuestionModel;
import cn.smarthse.services.train.api.model.question.TrainingQuestionParamModel;
import cn.smarthse.services.train.api.model.question.TraningQuestionModel;
import cn.smarthse.services.train.api.vo.question.QuestionFormVo;
import com.github.pagehelper.PageInfo;

import java.util.List;

/**
 * @author zhoulj(周利军) [1217102780@qq.com]
 * @Title: IQuestionService
 * @Project:
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments: <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.8> 12
 * @since 2021/1/27-10:12
 */
public interface ITrainingQuestionService extends IBaseService<TrainingQuestion> {
    
    /**
     * @Comments:  <保存或更新 题库信息>
     * @author zhoulj(周利军) [1217102780@qq.com]
     * @since 2021/1/27-16:24
     * @param formVo        题信息
     * @param areaId        编辑人所属区域
     * @param loginUserId   编辑账号
     * @return void
    */
    public void saveOrUpdateQuestionFormVo(QuestionFormVo formVo, Long areaId, Long loginUserId);

    /**
     * @Comments:  <禁用和启用 试题>
     * @author zhoulj(周利军) [1217102780@qq.com]
     * @since 2021/1/29-9:41
     * @param questionId
     * @param state
     * @return int
    */
    public int disableOrEnableQuestion(Long questionId, Integer state,Long loginStaffId);
    /**
     * @Comments:  <查询题库>
     * @author zhoulj(周利军) [1217102780@qq.com]
     * @since 2021/1/27-16:48
     * @param param
     * @return java.util.List<cn.smarthse.services.train.api.model.question.TraningQuestionModel>
    */
    public List<TraningQuestionModel> listTraningQuestionModel(TrainingQuestionParamModel param);

    public PageInfo<TraningQuestionModel> pageTraningQuestionModel(JqGridParam jparam, TrainingQuestionParamModel param);


    public TraningQuestionModel getTraningQuestionModel(Long questionId);

    public void saveQuestionFormVoList(List<QuestionFormVo> questionFormVoList, Long loginUserAreaId, Long loginStaffId);

    /**
	 * pc端-线下培训考试：查询培训用户的培训考试试题列表
	 * @author liaoly
	 * @date 2021年2月1日 上午10:10:03
	 * @param trainingExamRuleId : 规则id(training_exam_rule.id)
	 * @param applyObject : 培训用户角色（1-主要负责人 2-职业卫生管理人员 3-劳动者）即：training_member.role可传入TrainingApplyObjectEnum.code
	 * @param riskIdList : 培训用户企业的 危害因素id集合
	 * @param industryIdList : 培训用户企业的 行业id集合
	 * @return List<QuestionModel>
	 */
	public List<QuestionModel> getTrainingQuestionModelList(Long trainingExamRuleId, String applyObject, List<Long> riskIdList, List<Long> industryIdList);
	
	/**
	 * pc端-线下培训考试：查询培训用户的培训考试试题信息(经过格式化之后的)
	 * @author liaoly
	 * @date 2021年2月1日 上午10:10:03
	 * @param trainingExamRuleId : 规则id(training_exam_rule.id)
	 * @param applyObject : 培训用户角色（1-主要负责人 2-职业卫生管理人员 3-劳动者）即：training_member.role可传入TrainingApplyObjectEnum.code
	 * @param riskIdList : 培训用户企业的 危害因素id集合
	 * @param industryIdList : 培训用户企业的 行业id集合
	 * @return ExamQuestionTypeModel
	 */
	public List<ExamQuestionTypeModel> getExamQuestionTypeModelList(Long trainingExamRuleId, String applyObject, List<Long> riskIdList, List<Long> industryIdList);
	
    /**
     * app端 - 查询题目详情
     * @author yangzp
     * @param questionId : 试题id
     * @return EduTrainingExamQuestionModel
     */
    EduTrainingExamQuestionModel getTrainingExamQuestionDetailModel(Long questionId);


	public void importData(String ossfile, Long loginStaffId,Long cid, Integer questionType, Integer dataSource) throws Exception;


	List<EduTrainingExamQuestionModel> getRandTrainingQuestion(EduTrainingQuestionParam param);

	/**
	 * 从题库中随机挑选指定数量的试题，并返回
	 * @param questionType : 试题类别(-1：选择题[1,2]；1：单选；2：多选；3：填空)
	 * @param type : 类别(1:职业卫生综合; 2:职业危害防护; 3:职业健康监护; 4:职业危害因素; 5:职业卫生三同时; 6:职业病; 7:放射卫生;)
	 * @param questionTotal : 试题数
	 * @param excludeIds : 排除掉的question.id
	 * @return
	 */
	List<TrainingQuestion> getRandomQuestionList(Integer questionType, Integer type, Integer questionTotal, List<Long> excludeIds);

	/**
	 * 从题库中随机挑选指定数量的试题，并返回
	 * @param questionType : 试题类别(-1：选择题[1,2]；1：单选；2：多选；3：填空)
	 * @param questionTotal : 试题数
	 * @param excludeIds : 排除掉的question.id
	 * @return
	 */
	List<TrainingQuestion> getRandomQuestionList(Integer questionType, Integer questionTotal, List<Long> excludeIds);

	/**
	 * 从题库中随机挑选一道试题，并返回
	 * @param questionType : 试题类别(-1：选择题[1,2]；1：单选；2：多选；3：填空)
	 * @param excludeIds : 排除掉的question.id
	 * @return
	 */
	TrainingQuestion getRandomQuestion(Integer questionType, List<Long> excludeIds);

	QuestionWithAnswerModel getQuestionModel(Long questionId);
}
