package cn.smarthse.services.train.api.service.personal;

import cn.smarthse.db.common.service.IBaseService;
import cn.smarthse.services.train.api.entity.personal.UserIntegralLog;
import cn.smarthse.services.train.api.enums.personal.UserIntegralTypeEnum;
import cn.smarthse.services.train.api.model.personal.UserIntegralLogModel;
import com.github.pagehelper.PageInfo;

import java.util.List;

/**
 * 用户积分流水记录
 * @Description 
 * @Author liaoly
 * @Date 2020年4月26日 下午4:11:39
 */
public interface IUserIntegralLogService extends IBaseService<UserIntegralLog> {
	
	/**
	 * 查询用户总积分列表
	 * @param pageNum : 当前第一页
	 * @param pageSize : 每页显示数据条数
	 * @param keyword : 模糊匹配关键字
	 * @return
	 */
	public PageInfo<UserIntegralLogModel> getUserIntegralModelList(int pageNum, int pageSize, String keyword);
	
	/**
	 * 查询用户的总积分列表
	 * @param keyword : 模糊匹配关键字
	 * @return
	 */
	public List<UserIntegralLogModel> getUserIntegralModelList(String keyword);
	
	/**
	 * 查询指定用户的积分列表
	 * @param pageNum : 当前第一页
	 * @param pageSize : 每页显示数据条数
	 * @param userId : 用户账号id
	 * @return
	 */
	public PageInfo<UserIntegralLogModel> getUserIntegralLogModelList(int pageNum, int pageSize, Long userId);
	
	/**
	 * 查询指定用户的积分列表
	 * @param userId : 用户账号id
	 * @return
	 */
	public List<UserIntegralLogModel> getUserIntegralLogModelList(Long userId);
	
	/**
	 * 添加积分流水记录
	 * @param userId : 用户账号id
	 * @param userIntegralTypeEnum : 积分类型枚举
	 * @param integral : 积分数(正数加积分，负数减积分)
	 */
	public void addUserIntegralLog(Long userId, UserIntegralTypeEnum userIntegralTypeEnum, Integer integral);
	
	/**
	 * 添加积分流水记录
	 * @param userId : 用户账号id
	 * @param businessId : 积分产生的业务数据id(用来关联积分和业务数据的，可以为空)
	 * @param userIntegralTypeEnum : 积分类型枚举
	 * @param integral : 积分数(正数加积分，负数减积分)
	 * @return 返回当前业务的积分流水对象 
	 */
	public UserIntegralLog addUserIntegralLog(Long userId, Long businessId, UserIntegralTypeEnum userIntegralTypeEnum, Integer integral);
	
	/**
	 * 添加积分流水记录(没有businessId的,即：类型为：6：分享积分；7：登入积分)
	 * @param userId : 用户账号id
	 * @param userIntegralTypeEnum : 积分类型枚举
	 */
	public void addUserIntegralLog(Long userId, UserIntegralTypeEnum userIntegralTypeEnum);
	
	/**
	 * 查询指定用户每天的积分列表
	 * @param pageNum : 当前第一页
	 * @param pageSize : 每页显示数据条数
	 * @param userId : 用户账号id
	 * @return
	 */
	public PageInfo<UserIntegralLogModel> getUserIntegralListGroupByDay(Integer pageNum, Integer pageSize, Long userId);
	
	/**
	 * 查询指定userId用户，指定积分类型当天的积分记录
	 * @param userId : 用户账号id
	 * @param userIntegralTypeEnum : 积分类型枚举
	 * @return
	 */
	public List<UserIntegralLogModel> getUserIntegralLogByCurrentDay(Long userId, UserIntegralTypeEnum userIntegralTypeEnum);

	/**
	 * 查询指定账号的每种积分类型当天的状态
	 * @param userId : 用户账号id
	 * @return
	 */
	List<UserIntegralLogModel> getUserIntegralLogModelByType(Long userId);
	
	/**
	 * 查询指定账号总积分
	 * @param userId : 用户账号id
	 * @return
	 */
	public Integer getIntegralSum(Long userId);
	
	/**
	 * 查询指定账号指定类型积分当日的总积分
	 * @param userId : 用户账号id
	 * @param userIntegralTypeEnum : 积分类型
	 * @return
	 */
	public int getIntegralSumByCurrentDay(Long userId, UserIntegralTypeEnum userIntegralTypeEnum);

	public List<String>  getIntegralSumStrGroupUserId();
}
