package cn.smarthse.services.train.api.service.personal;

import cn.smarthse.services.train.api.enums.personal.UserIntegralTypeEnum;
import cn.smarthse.services.train.api.model.personal.UserIntegralLogModel;
import com.github.pagehelper.PageInfo;

import java.util.List;

/**
 * 用户积分模块服务-提供给职业健康app后端的
 * @Description 
 * @Author liaoly
 * @Date 2020年4月27日 下午4:36:41
 */
public interface IUserIntegralLogProvideService {
	
	/**
	 * 查询用户的总积分列表
	 * @param pageNum : 当前第一页
	 * @param pageSize : 每页显示数据条数
	 * @param keyword : 模糊匹配关键字
	 * @return
	 */
	public PageInfo<UserIntegralLogModel> getUserIntegralModelList(int pageNum, int pageSize, String keyword);

	/**
	 * 查询指定用户的积分列表
	 * @param pageNum : 当前第一页
	 * @param pageSize : 每页显示数据条数
	 * @param userId : 用户账号id
	 * @return
	 */
	PageInfo<UserIntegralLogModel> getUserIntegralLogModelList(int pageNum, int pageSize, Long userId);
	
	/**
	 * 查询指定用户每天的积分列表
	 * @param pageNum : 当前第一页
	 * @param pageSize : 每页显示数据条数
	 * @param userId : 用户账号id
	 * @return
	 */
	public PageInfo<UserIntegralLogModel> getUserIntegralListGroupByDay(Integer pageNum, Integer pageSize, Long userId);
	
	/**
	 * 添加积分流水记录(没有businessId的,即：类型为：登入、分享)
	 * @param userId : 用户账号id
	 * @param userIntegralTypeEnum : 积分类型枚举
	 */
	public void addUserIntegralLog(Long userId, UserIntegralTypeEnum userIntegralTypeEnum);
	
	/**
	 * 查询指定账号的每种积分类型当天的状态
	 * @param userId : 用户账号id
	 * @return
	 */
	List<UserIntegralLogModel> getUserIntegralLogModelByType(Long userId);
	
	/**
	 * 查询指定账号总积分
	 * @param userId : 用户账号id
	 * @return
	 */
	public Integer getIntegralSum(Long userId);
}
