
package cn.smarthse.services.train.api.service.member;

import cn.smarthse.db.common.service.IBaseService;
import cn.smarthse.services.train.api.entity.member.TrainingExamLog;
import cn.smarthse.services.train.api.enums.ExamStateEnum;
import cn.smarthse.services.train.api.enums.TrainingExamTypeEnum;
import cn.smarthse.services.train.api.model.exam.TrainingUserExamLogModel;
import cn.smarthse.services.train.api.pojo.vo.exam.TrainingExamResultVo;

import java.util.List;

/**
 * 答题记录service
 * 
 * @Author liaoly(廖凌云) [1302013247@qq.com]
 * @Date 2021年1月27日 下午4:28:37
 */
public interface ITrainingExamLogService extends IBaseService<TrainingExamLog>{

    /**
     * @Description  查询用户预考核/考试 记录(状态为（1、已通过，2、未通过)的考试
     * @Author Wuxq
     * @Date 9:50 2021/1/29
     * @Param [memberId, examType]
     * @return java.util.List<cn.smarthse.modules.eduTraining.model.EduTrainingUserExamLogModel>
     **/
    List<TrainingUserExamLogModel> getTrainingUserExamLogList(Long memberId, Integer examType);
    
    /**
	 * 查询考试记录列表(TrainingExamLog对象列表)
	 * @author liaoly
	 * @date 2021年3月1日 上午8:42:52
	 * @param memberId : trainingMember.id
	 * @param trainingExamType : 考试类别枚举(training_exam_log.examType)
	 * @param examStateEnum : 考试状态枚举（training_exam_log.state）
	 * @return List<TrainingUserExamLogModel>
	 */
	List<TrainingUserExamLogModel> getTrainingUserExamLogList(Long memberId, TrainingExamTypeEnum trainingExamType, ExamStateEnum examStateEnum);

    /**
     * 查询用户考试结果
     * @author haosw
     * @date 2021/2/2 9:54
     * @param examId: 试卷id
     * @return
    */
    TrainingExamResultVo getTrainingUserResult(Long examId);

    /**
     * 保存用户考试结果
     * @author haosw
     * @date 2021/2/3 9:17
     * @param examLog:
     * @return
    */
    void saveTrainingExamResult(TrainingExamLog examLog);

	/**
	 * 根据timeMemberId查询TrainingExamLog列表
	 * @author liaoly
	 * @date 2021年2月3日 下午12:22:51
	 * @param timeMemberId : training_exam_time_member.id
	 * @param examTypeEnum : ExamTypeEnum
	 * @return List<TrainingExamLog>
	 */
	List<TrainingExamLog> getTrainingExamLogList(Long timeMemberId, TrainingExamTypeEnum examTypeEnum);
	
	/**
	 * 根据timeMemberId查询TrainingExamLog
	 * @author liaoly
	 * @date 2021年2月3日 下午12:22:51
	 * @param timeMemberId : training_exam_time_member.id
	 * @param examTypeEnum : ExamTypeEnum
	 * @return TrainingExamLog
	 */
	TrainingExamLog getTrainingExamLog(Long timeMemberId, TrainingExamTypeEnum examTypeEnum);

	/**
	 * 初始化实际答题时间(有值的话不更新)
	 * @author liaoly
	 * @date 2021年2月3日 下午5:16:45
	 * @param timeMemberId : training_exam_time_member.id
	 * @param examTypeEnum : ExamTypeEnum
	 * @return TrainingExamLog.id
	 */
	Long initBeginTime(Long timeMemberId, TrainingExamTypeEnum offline3);

	/**
	 * 判断指定logId数据的状态是否是"已考试(状态（1、已通过，2、未通过）)"
	 * @author liaoly
	 * @date 2021年2月5日 下午1:31:55
	 * @param logId : training_exam_log.id
	 * @return boolean 状态是（1、已通过，2、未通过）返回true，反正返回false
	 */
	boolean hasExamed(Long currentLogId);
}
