
package cn.smarthse.services.train.api.service.member;

import cn.smarthse.db.common.service.IBaseService;
import cn.smarthse.services.train.api.entity.member.TrainingExamLogDetail;
import cn.smarthse.services.train.api.model.member.ExamLogDetailModel;
import cn.smarthse.services.train.api.model.question.TrainingQuestionCorrectRateModel;

import java.util.List;

/**
 * 考试记录详情service
 * 
 * @Author liaoly(廖凌云) [1302013247@qq.com]
 * @Date 2021年1月27日 下午4:30:25
 */
public interface ITrainingExamLogDetailService extends IBaseService<TrainingExamLogDetail>{

    /**
     * @Description  根据试题id(training_question.id)获取 答题人数，正确率
     * @Author Wuxq
     * @Date 11:02 2021/2/1
     * @Param [ question_id ]
     * @return
     **/
    public TrainingQuestionCorrectRateModel getAnswersNumAndCorrectRateByQuestionId(Long questionId);

    /**
     * 根据考试id获取相关的记录详情
     * @author haosw 
     * @date 2021/2/3 9:28
     * @param logId: 考试id
     * @return
    */
    List<TrainingExamLogDetail> getExamLogDetailByLogId(Long logId);
    
    /**
	 * 根据trainingExamLogId查询用户的一条正式考试的所有试题答题详情列表
	 * @author liaoly
	 * @date 2021年2月3日 下午12:05:15
	 * @param trainingExamLogId : TrainingExamLog.id
	 * @return List<ExamLogDetailModel>
	 */
	public List<ExamLogDetailModel> getExamLogDetailModelList(Long trainingExamLogId);
}
