package cn.smarthse.services.train.api.service.exam;


import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.db.common.service.IBaseService;
import cn.smarthse.services.train.api.entity.exam.TrainingExamTime;
import cn.smarthse.services.train.api.model.exam.TrainingUserExamTimeModel;
import cn.smarthse.services.train.api.pojo.dto.exam.TrainingExamTimeDto;
import cn.smarthse.services.train.api.pojo.dto.exam.TrainingExamTimesAddDto;
import cn.smarthse.services.train.api.pojo.vo.exam.TrainingExamTimeVo;
import com.github.pagehelper.PageInfo;

import java.util.List;
import java.util.Map;

/**
 * <p>
 * 培训考试时间 服务类
 * </p>
 *
 * @author haosw
 * @since 2021-01-21
 */
public interface ITrainingExamTimeService extends IBaseService<TrainingExamTime> {
    /**
     * 考试时间维护查询
     * @author haosw
     * @date 2021/1/22 14:13
     * @param dto:
     * @return
    */
    PageInfo<TrainingExamTimeVo> getExamTimeAndTotal(JqGridParam jparam, TrainingExamTimeDto dto);

    /**
     * 返回未完成考试且报名人数不为0的所有日期
     * @author haosw
     * @date 2021/1/26 9:05
     * @return
    */
    Map<Long,Integer> getBanExamTime();

    /**
     * 获取最近一次的考试时间信息
     * @author haosw
     * @date 2021/1/26 9:09
     * @return
    */
    TrainingExamTimeVo getLastExamTimeInfo();

    /**
     * 新增/更新多个日期的考试时间信息
     * @author haosw
     * @date 2021/1/26 9:17
     * @param dto:
     * @return
     */
    void addExamTimes(TrainingExamTimesAddDto dto);

    /**
     * @Description  线下考试报名列表
     * @Author Wuxq
     * @Date 9:51 2021/2/1
     * @Param []
     * @return cn.smarthse.modules.eduTraining.model.EduTrainingUserExamTimeModel
     **/
    List<TrainingUserExamTimeModel>  getExamSignUpList(Long memberId);
}
