package cn.smarthse.services.train.api.service.exam;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.db.common.service.IBaseService;
import cn.smarthse.services.train.api.entity.exam.TrainingExamTimeMember;
import cn.smarthse.services.train.api.enums.ExamStateEnum;
import cn.smarthse.services.train.api.model.exam.TrainingExamTimeMemberModel;
import cn.smarthse.services.train.api.pojo.vo.exam.TrainingExamPeoplesVo;
import com.github.pagehelper.PageInfo;

import java.util.List;

/**
 * <p>
 * 培训考试参与人表 服务类
 * </p>
 *
 * @author yangzp
 * @since 2021-01-21
 */
public interface ITrainingExamTimeMemberService extends IBaseService<TrainingExamTimeMember> {
    /**
     * 根据考试时间id及考试状态获取报名人员列表
     * @author haosw 
     * @date 2021/1/25 14:30
     * @param timeId: 考试时间id
     * @param examState: 考试状态 0:已报名 1：合格 2：已考试
     * @return
    */
    PageInfo<TrainingExamPeoplesVo> getTrainExamPeoples(JqGridParam jparam, Long timeId, Integer examState);

    /**
     * 根据考试时间id及考试状态获取报名人员List
     * @author haosw
     * @date 2021/1/28 13:57
     * @param timeId: 考试时间id
     * @param examState: 试状态 null:已报名 1：已考试 2：合格
     * @return
    */
    List<TrainingExamPeoplesVo> getTrainExamPeopleList(Long timeId,Integer examState);

    /**
	 * 获取最近一次的TrainingExamTimeMember(training_exam_time.begin_time最大的)
	 * @author liaoly
	 * @date 2021年1月27日 下午5:22:10
	 * @param memberId : 用户id(training_member.id)
	 * @return TrainingExamTimeMember
	 */
	TrainingExamTimeMemberModel getTrainingExamTimeMember(Long memberId);
	
	/**
	 * 获取培训人员的TrainingExamTimeMember集合(多家企业的会出现)
	 * @author liaoly
	 * @date 2021年1月27日 下午5:22:10
	 * @param idcard : 用户idcard(training_member.idcard)
	 * @param trainingYear : 用户idcard(training_member.idcard)
	 * @return List<TrainingExamTimeMemberModel>
	 */
	List<TrainingExamTimeMemberModel> getTrainingExamTimeMemberList(String idcard, int trainingYear);
	
	/**
	 * 获取培训人员的TrainingExamTimeMember集合(多家企业的会出现，会查询指定状态的考试)
	 * @author liaoly
	 * @date 2021年1月27日 下午5:22:10
	 * @param idcard : 用户idcard(training_member.idcard)
	 * @param trainingYear : 用户idcard(training_member.idcard)
	 * @param examStateEnum : 考试状态枚举
	 * @return List<TrainingExamTimeMemberModel>
	 */
	List<TrainingExamTimeMemberModel> getTrainingExamTimeMemberList(String idcard, int trainingYear, ExamStateEnum examStateEnum);
	
	/**
	 * 判断是否报名过考试
	 * @author liaoly
	 * @date 2021年1月28日 上午10:47:58
	 * @param memberId : 用户id(training_member.id)
	 * @return boolean 报名过返回true，未报名返回false
	 */
	boolean hasSignUp(Long memberId);

	/**
	 * @Description  线下考试报名
	 * @Author Wuxq
	 * @Date 9:20 2021/2/2
	 * @Param [memberId, examTimeId]
	 * @return java.lang.Boolean true:报名成功：false，已报满
	 **/
	Integer signUp(Long memberId, Long examTimeId);

	/**
	 * @Description  查询当前培训人员本年度 大于当前时间 未参加的考试列表
	 * @Author Wuxq
	 * @Date 10:33 2021/3/5
	 * @Param [memberId]
	 * @return java.util.List<cn.smarthse.services.train.api.entity.exam.TrainingExamTimeMember>
	 **/
	List<TrainingExamTimeMember> getSignUppedExamList(Long memberId);
}
