package cn.smarthse.services.train.api.service.exam;

import cn.smarthse.db.common.service.IBaseService;
import cn.smarthse.services.train.api.entity.exam.TrainingExam;

/**
 * <p>
 * 培训考试信息 服务类
 * </p>
 *
 * @author zhoulj(周利军) [1217102780@qq.com]
 * @since 2022-02-08
 */
public interface ITrainingExamService extends IBaseService<TrainingExam> {

    /**
     * @Comments:  <生成试卷信息>
     * @author zhoulj(周利军) [1217102780@qq.com]
     * @since 2022/2/8-14:43
     * @param testTemplateId
     * @return void
    */
    public void generateExam(Long testTemplateId, Long trainPlanId);
    /**
     * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
     * @author zhoulj(周利军) [1217102780@qq.com]
     * @since 2022/2/9-17:02
     * @param trainPlanId
     * @return void
    */
    public TrainingExam getExamInfoByTrainPlanId(Long trainPlanId);

    /**
     * @Comments:  <考试设置有变更》》统一重新生成试卷>
     * @author zhoulj(周利军) [1217102780@qq.com]
     * @since 2022/2/8-15:11
     * @param testTemplateId
     * @return void
    */
    public void resetExamByTemplateId(Long testTemplateId);
}
