package cn.smarthse.services.train.api.service.exam;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.db.common.service.IBaseService;
import cn.smarthse.services.train.api.entity.exam.TrainingExamRule;
import cn.smarthse.services.train.api.pojo.vo.exam.TrainingExamRuleAndDetailVo;
import com.github.pagehelper.PageInfo;

import java.util.List;

/**
 * <p>
 * 培训考试试题规则 服务类
 * </p>
 *
 * @author haosw
 * @since 2021-01-22
 */
public interface ITrainingExamRuleService extends IBaseService<TrainingExamRule> {

    /**
     * 添加/更新考试试题规则及详情
     * @author haosw
     * @date 2021/1/22 16:52
     * @param vo:
     * @return
    */
    void updTranExamRuleAndDetails(TrainingExamRuleAndDetailVo vo);

    /**
     * 根据id获取规则及详情
     * @author haosw 
     * @date 2021/1/25 8:40
     * @return
    */
    List<TrainingExamRuleAndDetailVo> getExamRuleAndDetail();

	/**
	 * 查询指定考试类型的的考试规则
	 * @author liaoly
	 * @date 2021年1月29日 下午4:45:43
	 * @param examTypeId : 考试类型id(可以用TrainingExamTypeEnum.id，和数据库保存一致的话)
	 * @return TrainingExamRule
	 */
	TrainingExamRule getByExamTypeId(Long examTypeId);

	/**
	 * 根据角色及考试类别获取相应考试规则及详情
	 * @author haosw
	 * @date 2021/2/3 9:02
	 * @param role: 人员角色
	 * @param examCategory: 考试类别
	 * @return
	*/
	TrainingExamRuleAndDetailVo getExamRuleAndDetailByRuleAndCategory(Byte role, String examCategory);

	/**
	 * 新增一个考试模板
	 * @param vo
	 */
	void addTranExamRuleAndDetails(TrainingExamRuleAndDetailVo vo);

	/**
	 * 根据id获取一个考试模板
	 * @param ruleId
	 * @return
	 */
	TrainingExamRuleAndDetailVo getTrainingExamRuleAndDetailByRuleId(Long ruleId);

	/**
	 * 获取公司试题模板
	 * @param cid
	 * @return
	 */
	List<TrainingExamRuleAndDetailVo> listTrainingExamRuleAndDetail(Long cid);
    PageInfo<TrainingExamRuleAndDetailVo> listTrainingExamRuleAndDetailPage(JqGridParam param, Long cid);

	/**
	 * 根据id删除试题模板
	 * @param id
	 */
	void deleteTrainingExamRule(Long id);


    List<TrainingExamRule> listTrainingExamRuleAndDetailByVo(TrainingExamRule vo);
}
