package cn.smarthse.services.train.api.service.challenganswer;


import cn.smarthse.db.common.service.IBaseService;
import cn.smarthse.services.train.api.entity.challenganswer.UserExam;
import cn.smarthse.services.train.api.model.challenganswer.UserExamModel;

import java.util.List;

/**
 * 用户-测试表
 * @Description 
 * @Author xiaoyi
 * @Date 2022年5月26日 下午4:10:57
 */
public interface IUserExamService extends IBaseService<UserExam> {

	/**
	 * 查询指定账号、指定试卷(答题)的
	 * @param userId
	 * @param examId
	 * @return
	 */
	public UserExam getUserExam(Long userId, Long examId);
	
	/**
	 * 查询指定账号、指定试卷(答题)的
	 * @param userId : 用户账号id
	 * @param examId : 试卷id
	 * @return
	 */
	public UserExamModel getUserExamModel(Long userId, Long examId);
	
	/**
	 * 查询指定用户的每周答题/专项答题
	 * @param userId
	 * @param isSpecial : 
	 * @return
	 */
	public List<UserExamModel> getUserExamModelList(Long userId, Boolean isSpecial);
	
	/**
	 * 查询指定用户当天的挑战答题
	 * @param userId : 指定账号id
	 */
	public List<UserExamModel> getChallengeUserExamModelList(Long userId);
	
	/**
	 * 挑战答题错误后 更新挑战答题数据
	 * @param examId : 挑战答题examChallenge.id
	 * @param userId : 用户账号id
	 */
	public UserExam updateTotalScoreForChallenge(Long examId, Long userId);
	
	/**
	 * 更新每周答题/专项答题 用户-试卷分数totalScore(没有答题完，默认为0分)
	 * @param examId
	 * @param userId
	 */
	public void updateTotalScore(Long examId, Long userId);
	
	/**
	 * 计算当前挑战答题examId的挑战答题积分(challengeTotalScore)
	 * @param examId : examId
	 * @param userId : 用户账号id
	 * @return
	 */
	public int computeChallengeTotalScore(Long examId, Long userId);
	
	/**
	 * 判断当前用户userId是否作答了指定examId 试题
	 * @param userId : 用户账号id
	 * @param examId : examId
	 * @return 没作答return false ， 反之return true
	 */
	public boolean isExam(Long userId, Long examId);
	
	/**
	 * 添加userExam(开始作答每周答题/专项答题)
	 * @param userId : 用户账号id
	 * @param examId : examId
	 */
	public void addUserExam(Long userId, Long examId);
}
