package cn.smarthse.services.train.api.service.challenganswer;


import cn.smarthse.db.common.service.IBaseService;
import cn.smarthse.services.train.api.entity.challenganswer.ExamQuestion;
import cn.smarthse.services.train.api.entity.challenganswer.UserExamQuestion;
import cn.smarthse.services.train.api.model.challenganswer.UserExamModel;
import cn.smarthse.services.train.api.model.challenganswer.UserExamQuestionModel;

import java.util.List;

/**
 * 用户-题目-答题结果表
 * @Description 
 * @Author xiaoyi
 * @Date 2022年5月26日 下午4:11:17
 */
public interface IUserExamQuestionService extends IBaseService<UserExamQuestion> {
	
	/**
	 * 添加用户-题目-答题信息(答题过程数据insert)
	 * @param userExamQuestionModel : 用户-题目-答题结果对象
	 * @return 返回答题结果对象
	 */
	UserExamQuestionModel addUserExamQuestion(UserExamQuestionModel userExamQuestionModel);
	
	/**
	 * 更新用户-题目-答题信息(答题过程数据更新)
	 * @param userExamQuestionModel : 用户-题目-答题结果对象
	 */
	void updateUserExamQuestion(UserExamQuestionModel userExamQuestionModel);
	
	/**
	 * 查询指定用户、指定试卷的答题列表
	 * @param userId : 用户账号id
	 * @param examId : 试题id
	 * @return
	 */
	List<UserExamQuestionModel> getUserExamQuestionList(Long userId, Long examId);
	
	/**
	 * 添加user_exam_question
	 * @param userId : 用户账号id
	 * @param examId : 试卷id
	 * @param questionId : 试题id
	 */
	UserExamQuestionModel addUserExamQuestion(Long userId, Long examId, Long questionId);
	
	/**
	 * 添加user_exam_question
	 * @param userId : 用户账号id
	 * @param examId : 试卷id
	 * @param examQuestionList : 试卷-试题集合(主要用questionId)
	 */
	List<UserExamQuestionModel> addUserExamQuestionList(Long userId, Long examId, List<ExamQuestion> examQuestionList);
	
	/**
	 * 查询指定试卷的最后一次答题(这里指的是挑战答题)
	 * @param examId : 试卷id
	 * @param userId : 用户账号id
	 * @return 
	 */
	UserExamQuestion getLastUserExamQuestion(Long examId, Long userId);
	
	/**
	 * 查询指定挑战答题的总分和连续答对的试题数
	 * @param examId : 挑战答题examChallenge.id
	 * @param userId : 用户账号id
	 * @return
	 */
	UserExamModel getChallengeTotalScore(Long examId, Long userId);
	
	/**
	 * 判断上一道题是否作答正确
	 * @param examId : 答题id
	 * @param userId : 用户账号id
	 * @return 上一道题答题错误则返回 false， 反之返回true
	 */
	boolean isRightForLastUserExamQuestion(Long examId, Long userId);
	
	/**
	 * 删除用户答题记录
	 * @param userId : 用户账号id
	 * @param examId : 答题id
	 */
	void deleteUserExamQuestionList(Long userId, Long examId);
	
	/**
	 * 判断指定每周答题/专项答题是否作答了
	 * @param userId : 用户账号id
	 * @param examId : 答题id
	 * @return
	 */
	boolean isAnswer(Long userId, Long examId);
}
