package cn.smarthse.services.train.api.service.challenganswer;


import cn.smarthse.db.common.service.IBaseService;
import cn.smarthse.services.train.api.entity.challenganswer.Exam;
import cn.smarthse.services.train.api.model.challenganswer.ExamModel;
import cn.smarthse.services.train.api.model.challenganswer.ExamMonthModel;
import cn.smarthse.services.train.api.model.challenganswer.UserExamQuestionModel;
import cn.smarthse.services.train.api.vo.challenganswer.UserExamVo;
import com.github.pagehelper.PageInfo;

import java.util.List;

/**
 * 答题表service(试卷)
 * @Description 
 * @Author xiaoyi
 * @Date 2022年5月26日 下午4:05:42
 */
public interface IExamService extends IBaseService<Exam> {

	/**
	 * 定时任务程序生成下周试卷），返回exam.id
	 */
	public Long createNextWeekExamByTask();
	
	/**
	 * 重新生成当前试卷试题
	 * @param examId : 试卷id
	 * @param type : 类别(1:职业卫生综合; 2:职业危害防护; 3:职业健康监护; 4:职业危害因素; 5:职业卫生三同时; 6:职业病; 7:放射卫生;)
	 * @param adminId : 操作账号id
	 */
	public void reCreateExam(Long examId, Integer type, Long adminId);
	
	/**
	 * 新增专项答题-试卷
	 * @param examModel
	 * @param adminId
	 */
	public Long addSpecialExam(ExamModel examModel, Long adminId);
	
	/**
	 * 查询试题列表
	 * @param isSpecial : 是否专项答题试卷(专项: true; 不是专项: false)
	 * @return
	 */
	public List<ExamModel> getExamList(Boolean isSpecial);
	
	/**
	 * 查询指定账号的 每周答题/专项答题
	 * @param userId : 当前用户账号id
	 * @param isSpecial : 是否专项答题试卷(专项: true; 不是专项: false)
	 * @param status : 状态ExamStatusEnum
	 * @return
	 */
	public List<ExamModel> getExamModelList(Long userId, Boolean isSpecial, Integer status);

	/**
	 * 查询指定账号的 每周答题/专项答题(按月分组)
	 * @param userId : 当前用户账号id
	 * @param isSpecial : 是否专项答题试卷(专项: true; 不是专项: false)
	 * @param status : 状态ExamStatusEnum
	 * @return
	 */
	public List<ExamMonthModel> getExamMonthModelList(Long userId, Boolean isSpecial, Integer status);
	/**
	 * 查询指定账号的 每周答题/专项答题(状态为已上架的)(按月分组)
	 * @param pageNum : 当前第一页
	 * @param pageSize : 每页显示数据条数
	 * @param userId : 当前用户账号id
	 * @param isSpecial : 是否专项答题试卷(专项: true; 不是专项: false)
	 * @return
	 */
	public PageInfo<ExamMonthModel> getExamMonthModelPage(int pageNum, int pageSize, Long userId, Boolean isSpecial);

	/**
	 * 查询指定用户、指定试卷的专项答题/每周答题详情
	 * @param userId : 用户账号id
	 * @param examId : 试卷id
	 */
	public UserExamVo getUserExamVo(Long userId, Long examId);
	/**
	 * 查询试题列表(分页)
	 * @param pageNum : 当前页数
	 * @param pageSize : 每页条数
	 * @param isSpecial : 是否专项答题试卷(专项: true; 不是专项: false)
	 * @return
	 */
	public PageInfo<ExamModel> getExamList(int pageNum, int pageSize, Boolean isSpecial);
	
	/**
	 * 查询指定账号的 每周答题/专项答题(状态为已上架的)
	 * @param pageNum : 当前第一页
	 * @param pageSize : 每页显示数据条数
	 * @param userId : 当前用户账号id
	 * @param isSpecial : 是否专项答题试卷(专项: true; 不是专项: false)
	 * @return
	 */
	public PageInfo<ExamModel> getExamModelListForApp(int pageNum, int pageSize, Long userId, Boolean isSpecial);


    /**
     * 查询指定账号的 每周答题/专项答题(状态为已上架的)(按月分组)
     * @param pageNum : 当前第一页
     * @param pageSize : 每页显示数据条数
     * @param userId : 当前用户账号id
     * @param isSpecial : 是否专项答题试卷(专项: true; 不是专项: false)
     * @return
     */
    public PageInfo<ExamMonthModel> getExamMonthModelListForApp(int pageNum, int pageSize, Long userId, Boolean isSpecial);

	
	/**
	 * 查询指定账号的 每周答题/专项答题
	 * @param pageNum : 当前第一页
	 * @param pageSize : 每页显示数据条数
	 * @param userId : 当前用户账号id
	 * @param isSpecial : 是否专项答题试卷(专项: true; 不是专项: false)
	 * @return
	 */
	public PageInfo<ExamModel> getExamModelList(int pageNum, int pageSize, Long userId, Boolean isSpecial);
	
	/**
	 * 查询每周答题/专项答题
	 * @param examId : 试卷id
	 * @return
	 */
	public ExamModel getExamModel(Long examId);
	
	/**
	 * 自动上架每周答题-试卷
	 */
	public void autoUpExam();
	
	/**
	 * 更新exam
	 * @param examModel
	 * @param adminId : 操作账号id
	 */
	public void updateExam(ExamModel examModel, Long adminId);
	
	/**
	 * 删除试卷
	 * @param examId : 试卷id
	 * @param adminId : 操作账号id
	 */
	public void delExam(Long examId, Long adminId);
	
	/**
	 * 更新exam.totalUser
	 */
	public void updateTotalUser();
	
	/**
	 * 试卷上架
	 * @param examId : 试卷id
	 * @param adminId : 操作账号id
	 */
	public void upExam(Long examId, Long adminId);

	/**
	 * 添加用户-题目-答题信息(答题过程数据insert)
	 * @param userExamQuestionModelList : 用户-题目-答题结果对象集合
	 * @param userId : 当前用户id
	 */
	public void addUserExamQuestionList(List<UserExamQuestionModel> userExamQuestionModelList, Long userId);
	/**
	 * 更新用户-题目-答题信息(答题过程数据更新)
	 * @param userExamQuestionModel : 用户-题目-答题结果对象
	 */
	void updateUserExamQuestion(UserExamQuestionModel userExamQuestionModel);

}
