package cn.smarthse.services.train.api.service.challenganswer;


import cn.smarthse.db.common.service.IBaseService;
import cn.smarthse.services.train.api.entity.challenganswer.ExamQuestion;
import cn.smarthse.services.train.api.model.challenganswer.ExamQuestionModel;
import cn.smarthse.services.train.api.model.challenganswer.UserExamQuestionModel;

import java.util.List;

/**
 * 测试-题目表
 * @Description 
 * @Author xiaoyi
 * @Date 2022年5月26日 下午4:08:11
 */
public interface IExamQuestionService extends IBaseService<ExamQuestion> {
	
	/**
	 * 随机创建试卷试题关系表数据(exam_question)
	 * @param examId : 试卷id
	 * @param type : 类别(1:职业卫生综合; 2:职业危害防护; 3:职业健康监护; 4:职业危害因素; 5:职业卫生三同时; 6:职业病; 7:放射卫生;)
	 * @param questionTotal : 所需试题数量
	 * @return 返回ExamQuestion集合
	 */
	List<ExamQuestion> createExamQuestionByRandom(Long examId, Integer type, int questionTotal);
	
	/**
	 * 查询试题-题目列表
	 * @param examId : 试卷id
	 * @return
	 */
	public List<ExamQuestionModel> getExamQuestionList(Long examId);
	
	/**
	 * 更新ExamQuestion.index(排序)
	 * @param examQuestionId : 试题-题目关系对象id
	 * @param index : 排序值
	 * @param adminId : 操作账号id
	 */
	void updateExamOptionIndex(Long examQuestionId, int index, Long adminId);
	
	/**
	 * 查询当前试卷的试题的最大index
	 * @param examId : 试卷id
	 * @return
	 */
	Integer getMaxIndex(Long examId);
	
	/**
	 * 删除试卷中的试题
	 * @param examQuestionId : 试卷试题关系id
	 * @param adminId : 操作账号id
	 */
	void delExamQuestion(Long examQuestionId, Long adminId);
	
	/**
	 * 批量删除指定试卷的试题(删除examQuestion关系)
	 * @param examId : 试卷id
	 * @param adminId : 操作账号id
	 */
	void delExamQuestions(Long examId, Long adminId);
	
	/**
	 * 挑战答题中随机添加一道题
	 * @param examId : 试卷id
	 * @param adminId : 用户账号id
	 */
	public ExamQuestionModel addChallengeExamQuestion(Long examId, Long adminId);
	
	/**
	 * 挑战答题中添加指定题目
	 * @param examId : 试卷id
	 * @param optionList
	 * @param adminId : 操作账号id
	 */
	void updateExamQuestionList(Long examId, List<Long> optionList, Long adminId);

	/**
	 * 添加用户-题目-答题信息(答题过程数据insert)
	 * @param userExamQuestionModel : 用户-题目-答题结果对象
	 */
	UserExamQuestionModel addUserExamQuestion(UserExamQuestionModel userExamQuestionModel);
}
