package cn.smarthse.services.train.api.service.challenganswer;


import cn.smarthse.db.common.service.IBaseService;
import cn.smarthse.services.train.api.entity.challenganswer.ExamChallenge;
import cn.smarthse.services.train.api.model.challenganswer.ExamChallengeModel;
import cn.smarthse.services.train.api.model.challenganswer.UserExamQuestionModel;
import cn.smarthse.services.train.api.vo.challenganswer.UserExamChallengeVo;

/**
 * 挑战答题-试题
 * @Description 
 * @Author xiaoyi
 * @Date 2022年5月27日 上午11:07:46
 */
public interface IExamChallengeService extends IBaseService<ExamChallenge> {

	/**
	 * 创建挑战答题(指定默认的试题数量)
	 * @param userId : 用户账号id
	 * @return 返回挑战答题主体 UserExamChallengeVo
	 */
	public UserExamChallengeVo createExamChallenge(Long userId);
	
	/**
	 * 创建挑战答题exam_challenge(不直接创建试题exam_question)
	 * @param userId : 用户账号id
	 * @return 返回挑战答题主体 UserExamChallengeVo
	 */
	public UserExamChallengeVo createExamChallengeDefault(Long userId);
	
	/**
	 * 查询挑战答题-试题
	 * @param examId : 试题id
	 * @return
	 */
	public ExamChallengeModel getExamChallengeModel(Long examId);

	/**
	 * 查询指定用户、指定试卷的挑战答题详情
	 * @param userId : 用户账号id
	 * @param examId : 试卷id
	 */
	public UserExamChallengeVo getUserExamChallengeVo(Long userId, Long examId);

	/**
	 * 2.添加用户-题目-答题信息(答题过程数据insert)
	 * @param userExamQuestionModel : 用户-题目-答题结果对象
	 * @return 返回答题结果对象
	 */
	UserExamQuestionModel addUserExamQuestion(UserExamQuestionModel userExamQuestionModel);
}
