package cn.smarthse.services.train.api.service.article;

import cn.smarthse.db.common.service.IBaseService;
import cn.smarthse.services.train.api.entity.video.UserVideoLearn;

/**
 * 
 * 视频/文章-学习时长（一个人一个视频只有一条数据）
 * 
 * @Author liaoly(廖凌云) [1302013247@qq.com]
 * @Date 2022年1月17日 下午1:36:49
 */
public interface IUserVideoLearnService extends IBaseService<UserVideoLearn> {
	
	/**
	 * 查询指定用户视频的学习详情
	 * @param userId : 用户账号id
	 * @param businessId : video.id
	 */
	UserVideoLearn getUserVideoLearn(Long userId, Long businessId);
	
	/**
	 * 保存学习时间
	 * @param userId : 用户账号id
	 * @param videoId : 视频id
	 * @param learnTime : 学习时长/ms（计时得到的）
	 * @param learnDot : 观看结束位置/ms（视频进度）
	 * @param status : 学习状态（0：未学习；1-学习中；2：已学习）
	 * @return Integer 返回学习状态
	 */
	Integer saveUserVideoLearn(Long userId, Long videoId, Integer learnTime, Integer learnDot, Integer status);

}
