package cn.smarthse.services.train.api.service.article;


import cn.smarthse.db.common.service.IBaseService;
import cn.smarthse.services.train.api.entity.article.UserLearn;

/**
 * 用户视频或者文章学习时长记录service
 * @Description 
 * @Author liaoly
 * @Date 2020年5月27日 上午8:46:13
 */
public interface IUserLearnService extends IBaseService<UserLearn> {
	
	/**
	 * 查询指定用户视频或文章当天的学习时间详情
	 * @param userId : 用户账号id
	 * @param businessId : article.id 或者 video.id
	 * @param type : 积分类型(4：视频学习积分；5：文章学习积分)
	 */
	UserLearn getUserLearn(Long userId, Long businessId, Integer type);
	
	/**
	 * 查询指定用户当天的学习时长
	 * @param userId : 用户账号id
	 * @param type : 积分类型(4：视频学习积分；5：文章学习积分)
	 */
	int getUserLearnByCurrentDay(Long userId, Integer type);
	
	/**
	 * 保存学习时间
	 * @param userId : 用户账号id
	 * @param businessId : 视频id或者文章id
	 * @param type : 积分类型(4：视频学习积分；5：文章学习积分)
	 * @param learnTime : 学习(阅读)时间/ms
	 */
	void saveLearnTime(Long userId, Long businessId, Integer type, Integer learnTime);

}
