package cn.smarthse.services.train.api.service.article;


import cn.smarthse.common.framework.jqgrid.JqGridData;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.db.common.service.IBaseService;
import cn.smarthse.services.train.api.entity.article.Article;
import cn.smarthse.services.train.api.entity.video.UserVideoLearn;
import cn.smarthse.services.train.api.model.article.AppCollectModel;
import cn.smarthse.services.train.api.model.article.ArticleModel;
import com.github.pagehelper.PageInfo;

import java.util.List;

/**
 * 在线培训： 文章模块服务接口
 */
public interface IArticlePlatformService  extends IBaseService<Article> {

	/**
	 * 后台文章列表
	 */
	JqGridData<ArticleModel> getList(String name, JqGridParam param);

	PageInfo<ArticleModel> getListPageInfo(String name, JqGridParam param);

	/**
	 * 新增数据
	 */
	Article addEntity(Article entity, Long createBy);

	/**
	 * 新增法律
	 * @param compiler : 编制人
	 * 返回没有导入的数据
	 */
	List<Article> addLaw(List<Article> list, String compiler, Long createBy);

	/**
	 * 编辑数据
	 */
	Integer edit(Article entity, Long createBy);

	/**
	 * 删除数据
	 */
	Integer del(Article entity, Long createBy);

	/**
	 * 查看数据
	 */
	ArticleModel view(Long id);
	
	/**
	 * 批量上架当天增加的文章和视频
	 * 
	 * 每天凌晨一天执行
	 */
	void active();

	//////////////////////////

	/**
	 * app文章列表
	 */
	JqGridData<ArticleModel> getAppList(JqGridParam param);

	/**
	 * app阅读
	 * 
	 * @param id
	 *            文章id
	 * @param uid
	 *            用户id
	 */
	ArticleModel updateArticle(Long id, Long uid);
	
	/**
	 * 查询文章详情(给没有登入的人用的)
	 * @param id : 文章id
	 * @return
	 */
	ArticleModel getArticle(Long id);

	/**
	 * app收藏
	 * 
	 * @param id
	 *            文章id
	 * @param uid
	 *            用户id
	 */
	void collect(Long id, Long uid);

	/**
	 * app取消收藏文章
	 * 
	 * @param id
	 *            文章id
	 * @param uid
	 *            用户id
	 */
	void uncollect(Long id, Long uid);
	
	/**
	 * app批量取消收藏
	 * 
	 * @param list
	 *            待取消收藏的文章+视频
	 * @param uid
	 *            用户id
	 */
	void batchUncollect(List<AppCollectModel> list, Long uid);

	/**
	 * app收藏列表
	 */
	JqGridData<AppCollectModel> collectList(Long uid, Integer type, JqGridParam param);
	
	/**
	 * 保存学习时间
	 * @param userId : 用户账号id
	 * @param businessId : 视频id或者文章id
	 * @param type : 积分类型(4：视频学习积分；5：文章学习积分)
	 * @param learnTime : 学习(阅读)时间/ms
	 * @param status : 学习状态（0：未学习；1-学习中；2：已学习）
	 */
	Integer saveLearnTime(Long userId, Long businessId, Integer type, Integer learnTime, Integer status);
	
	/**
	 * 保存用户-视频-学习状态数据
	 * 
	 * @author liaoly
	 * @date 2022年1月17日 下午2:00:24
	 * @param userId : 用户账号id
	 * @param videoId : 视频id
	 * @param learnTime : 学习时长/ms（计时得到的）
	 * @param learnDot : 观看结束位置/ms（视频进度）
	 * @param status : 学习状态（0：未学习；1-学习中；2：已学习）
	 * void 
	 * @return 
	 * 
	 */
	Integer saveUserVideoLearn(Long userId, Long videoId, Integer learnTime, Integer learnDot, Integer status);
	
	/**
	 * 
	 * 查询用户视频学习信息
	 * 
	 * @author liaoly
	 * @date 2022年1月20日 上午9:19:28
	 * @param userId : 用户账号id
	 * @param videoId : 视频id
	 * @return UserVideoLearn 返回视频学习信息
	 */
	UserVideoLearn getUserVideoLearn(Long uid, Long videoId);

    void upOrDownShelves(Long id, Integer status,Long uid);

    void delById(Long id, Long userId);
}
