package cn.smarthse.services.train.api.service;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.db.common.service.IBaseService;
import cn.smarthse.modules.common.model.TrainCompanyModel;
import cn.smarthse.modules.health.supervise.vo.staff.ThirdStaffInfoVo;
import cn.smarthse.services.train.api.entity.TrainingMember;
import cn.smarthse.services.train.api.model.TrainingMemberModel;
import cn.smarthse.services.train.api.model.TransformTrainingMemberModel;
import cn.smarthse.services.train.api.pojo.vo.exam.TrainingMemeberCountVo;
import cn.smarthse.services.train.api.vo.TrainingMemberSearchVO;
import com.github.pagehelper.PageInfo;

import java.math.BigDecimal;
import java.util.List;

/**
 * <p>
 * 培训人员表 服务类
 * </p>
 *
 * @author yangzp
 * @since 2021-01-21
 */
public interface ITrainingMemberService extends IBaseService<TrainingMember> {

    /**
     * 根据条件查询培训人员列表(分页)
     * @param jParam 前端条件
     * @param searchVo 查询条件
     * @return
     */
    PageInfo<TrainingMemberModel> getPageTrainingMember(JqGridParam jParam, TrainingMemberSearchVO searchVo);

    /**
     * 获取条件查询的培训人员的列表
     * @param searchVo 查询条件
     * @return
     */
    List<TrainingMemberModel> getListTrainStaffBySearch(TrainingMemberSearchVO searchVo);

    /*
     * @Description:获取企业年度培训人员列表分页
     * @Author: XiaoYi(肖奕)
     * @Date: 2021/1/25 13:32
     * @param: [jParam, searchVo]
     * @return: com.github.pagehelper.PageInfo<cn.smarthse.services.train.api.model.TrainingMemberModel>
     **/
    PageInfo<TrainingMemberModel> getTraningMemberBYCid(JqGridParam jParam, TrainingMemberSearchVO searchVo);


    List<TrainingMemberModel> getTraningMemberListBYCid(TrainingMemberSearchVO searchVo);



    /**
     * 根据人员id查询人员详情
     * @param staffId 人员id
     * @return
     */
    ThirdStaffInfoVo trainMemberInfo(Long staffId);

    /**
     * 根据id查询本条培训人员信息数据
     * @param id id
     * @return
     */
    ThirdStaffInfoVo trainMemberInfoById(Long id);


    /**
     * 查询个人在线培训记录(分页)
     * @param jParam 分页条件
     * @param staffId 人员id
     * @return
     */

    PageInfo<TrainingMemberModel> getTrainMemberLogList(JqGridParam jParam, Long staffId);
    /*
     * @Description:获取人员本年度人员培训几率
     * @Author: XiaoYi(肖奕)
     * @Date: 2021/1/27 9:16
     * @param: [id, year]
     * @return: cn.smarthse.services.train.api.entity.TrainingMember
     **/
    TrainingMember getByStaffIdThisYear(Long id, int year);

    /**
     * 根据企业id获取培训人员(未分页数据)
     * @param searchVo 查询条件
     * @return
     */
    List<TrainingMemberModel> getListTraningMemberBYCid(TrainingMemberSearchVO searchVo);

    /**
     * 根据年份查询
     * @param year
     * @return
     */
    List<TrainingMember> getByYear(Integer year);
    /**
     * 根据年份查询 根据staffId获取本年度培训信息
     * @param staffId
     * @return
     */
    TrainingMemberModel getTrainInfoByStaffId(Long staffId,Long cid);

    /**
     * @Description  根据 staffId 查询 用户 历年培训记录
     * @Author Wuxq
     * @Date 14:07 2021/1/29
     * @Param [idCard,cid]
     * @return java.util.List<cn.smarthse.modules.eduTraining.model.EduTrainingMemberModel>
     **/
    List<TransformTrainingMemberModel> getTrainingMemberListByStaffId(String idCard ,Long cid);

    /**
	 * 根据身份证 和 企业id 查询当年的 trainingMember.id
	 * @author liaoly
	 * @date 2021年2月2日 下午4:24:48
	 * @param idCard : 身份证
	 * @param cid : 企业id
	 * @param trainingYear : 培训年度
	 * @return Long 返回 TrainingMember.id
	 */
	Long getMemberIdByIdcardAndCidThisYear(String idCard, Long cid, int trainingYear);

	/**
	 * 根据trainingMember信息获取requireHour
	 * 	角色                            初训            复训
	 *	主要负责人                 16学时        8学时
	 *	职业卫生管理人员      16学时        8学时
	 *	劳动者                         8学时         4学时
	 * @author liaoly
	 * @date 2021年2月4日 下午1:25:35
	 * @param trainingMember
	 * @return BigDecimal
	 */
	BigDecimal getRequireHour(TrainingMember trainingMember);


	/**
	* @Description: 根据信息查询企业列表
	* @Param: searchVo
	* @return: List<Long>
	* @Author: yangzp
	* @Date: 2021/2/22 9:17
	*/
    List<Long> getTrainMemberCidList(TrainingMemberSearchVO searchVo);

    /**
     * 查看本年度企业的主要负责人，管理员以及劳动者数量
     * @param id 公司id
     * @param year 培训年份
     * @return
     */
    TrainCompanyModel selectRoleNameByCid(Long id, Integer year);

	TrainingMemeberCountVo getCompanyTrainingMemeberCount(Long cid, Integer year);
}
