package cn.smarthse.services.train.api.pojo.vo.exam;




import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * <p>
 * 培训考试时间
 * </p>
 *
 * @author haosw
 * @since 2021-01-21
 */
@Data
@ApiModel(value="TraningExamTimeModel对象", description="培训考试时间")
public class TrainingExamTimeVo implements Serializable {

    @ApiModelProperty(value = "ID")
    private Long id;

    @ApiModelProperty(value = "考试结束时间")
    private LocalDateTime endTime;

    @ApiModelProperty(value = "考试地点")
    private String address;

    @ApiModelProperty(value = "满额人数")
    private Integer total;

    @ApiModelProperty(value = "考试开始时间")
    private LocalDateTime beginTime;

    @ApiModelProperty(value = "报名人数")
    private Integer applyTotal;

    @ApiModelProperty(value = "考试人数")
    private Integer examTotal;

    @ApiModelProperty(value = "合格人数")
    private Integer qualifiedTotal;
}
