package cn.smarthse.services.train.api.pojo.vo.exam;

import cn.smarthse.services.train.api.entity.exam.TrainingExamRuleDetail;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

/**
 * @author haosw
 * @Description 培训考试试题规则及详情
 * @date 2021/1/22
 */
@Data
public class TrainingExamRuleAndDetailVo implements Serializable {

    @ApiModelProperty(value = "ID")
    private Long id;

    @ApiModelProperty(value = "适用区域")
    private Long areaId;

    @ApiModelProperty(value = "考试类型id")
    private Long examTypeId;

    @ApiModelProperty(value = "考核题目")
    private String assessTopic;

    @ApiModelProperty(value = "考核时间")
    private Integer assessTime;

    @ApiModelProperty(value = "合格分数")
    private Integer passScore;

    @ApiModelProperty(value = "总分")
    private Integer totalScore;

    @ApiModelProperty(value = "最后修改人ID")
    private Long updateBy;

    private Long createBy;

    private Integer dataSource;

    private Long cid;

    @ApiModelProperty(value = "规则详情")
    private List<TrainingExamRuleDetail> details;


    public Integer getTotalNum(){
        int sum=0;
        if (details.size()==0){
            return sum;
        }
        for (TrainingExamRuleDetail detail : details) {
            Integer num = detail.getNum();
            if (num != null) {
                sum=sum+num;
            }

        }
        return sum;
    }

    public Integer getTotalScore() {
        AtomicInteger totalScore = new AtomicInteger(0);
        if(details!=null&&details.size()>0){
            details.forEach(item->{
                if (item!=null &&item.getNum() != null && item.getEachScore() != null) {
                    totalScore.addAndGet(item.getNum() * item.getEachScore());
                }
            });
        }
        return totalScore.get();
    }
}
