package cn.smarthse.services.train.api.pojo.dto.exam;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @author haosw
 * @Description 考试时间新增对象
 * @date 2021/1/29
 */
@Data
@ApiModel(value="多个考试时间新增对象", description="多个考试时间新增对象")
public class TrainingExamTimesAddDto implements Serializable {

    @ApiModelProperty(value = "考试时间-开始时间")
    private String beginTime;

    @ApiModelProperty(value = "考试时间-结束时间")
    private String endTime;

    @ApiModelProperty(value = "考试地点")
    private String address;

    @ApiModelProperty(value = "满额人数")
    private Integer total;

    @ApiModelProperty(value = "创建人")
    private Long createBy;

    @ApiModelProperty(value = "考试日期集合")
    private List<Long> examDate;
}
