package cn.smarthse.services.train.api.model.video;

import cn.smarthse.modules.datacentre.model.system.SysFileModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

@ApiModel("视频详情")
public @Data class VideoModel implements Serializable {
	private static final long serialVersionUID = 1L;

	@ApiModelProperty(value = "主键")
	private Long id;

	@ApiModelProperty(value = "视频名称")
	private String name;

	@ApiModelProperty(value = "视频类别 TrainingTypeEnum")
	private Integer type;

	@ApiModelProperty(value = "视频url")
	private String url;

	@ApiModelProperty(value = "腾讯视频url")
	private String txUrl;

	@ApiModelProperty(value = "三方视频会有个vid，小程序用的 腾讯视频，有vid（保存接口会分析url提取出vid）")
	private String vid;

	@ApiModelProperty(value = "视频来源")
	private String source;

	@ApiModelProperty(value = "视频大小/B")
	private String size;

	@ApiModelProperty(value = "视频时长/秒")
	private String minutes;

	@ApiModelProperty(value = "状态(1:草稿；2:上架)")
	private Integer status;

	@ApiModelProperty(value = "视频描述")
	private String description;

	@ApiModelProperty(value = "上架时间")
	private java.util.Date shelvesTime;

	@ApiModelProperty(value = "视频截图sys_file.id， 逗号分隔")
	private String screenshot;
	
	@ApiModelProperty(value = "视频截图url")
	private String screenshotUrl;
	
	@ApiModelProperty(value = "编制人")
	private String compiler;
	
	@ApiModelProperty(value = "创建人")
	private Long createBy;

	@ApiModelProperty(value = "创建时间")
	private java.util.Date createDate;

	@ApiModelProperty(value = "最后修改人ID")
	private Long updateBy;

	@ApiModelProperty(value = "最后修改时间")
	private java.util.Date updateDate;

	@ApiModelProperty(value = "是否有效（0-无效，1-有效）")
	private Boolean isValid;

	/////////////////////////

	@ApiModelProperty(value = "点击量")
	private Long hot;

	@ApiModelProperty(value = "点赞数")
	private Long up;

	@ApiModelProperty(value = "收藏数")
	private Long collect;
	
	@ApiModelProperty(value = "是否被当前用户收藏")
	private Boolean isCollect;
	
	@ApiModelProperty(value = "学习状态: 0-未学习；1-学习中；2-已学习(学习时长*0.8>=视频时长)")
	private Byte learnStatus;
	
	@ApiModelProperty(value = "学习时长")
	private Long learnTime;
	
	@ApiModelProperty(value = "收藏时间")
	private java.util.Date collectionTime;

	@ApiModelProperty(value = "视频截图url")
	private List<SysFileModel> picList;
	
	@ApiModelProperty(value = "创建人")
	private String createByStr;
	
	//学习状态: 0-未学习；1-学习中；2-已学习(学习时长*0.8>=视频时长)
	public Byte getLearnStatus() {
		return this.learnStatus == null ? 0 : this.learnStatus;
	}
//	public Byte getLearnStatus() {
//		
//		//String minutes = this.getMinutes(); //视频时长格式eg：1:45:35 表示1h45min35s
//		
//		int minute = 0 ; //视频学习时长/ms
//		
//		if (this.getLearnTime() == null) return 0;
//		
//		if (!StringUtils.isEmpty(this.getMinutes())) {
//			String[] minuteArr = this.minutes.split(":");
//			
//			if (minuteArr.length == 1) 
//				minute = 0;
//			
//			if (minuteArr.length == 2) { //eg 45:35
//				minute = (Integer.parseInt(minuteArr[0]) * 60 + Integer.parseInt(minuteArr[1])) * 1000;
//			}
//			
//			if (minuteArr.length == 3) { //eg 01:45:35
//				minute = (Integer.parseInt(minuteArr[0]) * 3600 + Integer.parseInt(minuteArr[1]) * 60 + Integer.parseInt(minuteArr[2])) * 1000;
//			}
//		}
//		
//		return (byte)(this.getLearnTime() == null || this.getLearnTime() == 0 ? 0 
//				: (this.getLearnTime() > 0 && this.getLearnTime() < minute * 0.8 ? 1 : 2));
//	}
}
