package cn.smarthse.services.train.api.model.video;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 培训课程model
 * 
 * @Author liaoly(廖凌云) [1302013247@qq.com]
 * @Date 2021年2月4日 上午10:15:07
 */
@Data
@ApiModel(value="培训课程model", description="培训课程model")
public class TrainingVideoModel implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "id")
    private Long id;
    
    @ApiModelProperty(value = "有效区域")
    private Long areaId;

    @ApiModelProperty(value = "视频名称")
    private String name;

    @ApiModelProperty(value = "视频时长")
    private Long videoTime;

    @ApiModelProperty(value = "对应学时")
    private BigDecimal learnHour;
    
    @ApiModelProperty(value = "视频来源")
    private String videoFrom;

    @ApiModelProperty(value = "培训讲师")
    private String trainingTeacher;

    @ApiModelProperty(value = "视频画面")
    private Long videoImgage;
    
    @ApiModelProperty(value = "视频文件")
    private Long videoFile;
    
    @ApiModelProperty(value = "视频简介")
    private String videoDescription;
}
