package cn.smarthse.services.train.api.model.video;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @ClassName TrainingVideoMemberModel
 * @Description 用户视频课程学习情况
 * @Author Wuxq
 * @Date 2021/1/27
 */
public @Data class TrainingVideoMemberModel implements Serializable {

	private static final long serialVersionUID = 5600680289191538960L;

	@ApiModelProperty(value = "ID")
    private Long id;

    @ApiModelProperty(value = "用户id")
    private Long memberId;

    @ApiModelProperty(value = "视频课程名称")
    private String videoName;
    
    @ApiModelProperty(value = "视频课程")
    private Long videoFile;
    
    @ApiModelProperty(value = "视频文件")
    private String videoFileUrl;
    
    @ApiModelProperty(value = "视频课程图片")
    private Long videoImage;
    
    @ApiModelProperty(value = "视频画面")
    private String videoImageUrl;

    @ApiModelProperty(value = "视频简介")
    private String videoDescription;

    @ApiModelProperty(value = "视频学习状态")
    private Integer status;

    @ApiModelProperty(value = "视频学习状态")
    private String statusStr;

    @ApiModelProperty(value = "对应学时")
    private BigDecimal learnHour;

    @ApiModelProperty(value = "视频时长")
    private Long videoTime;

    @ApiModelProperty(value = "已学习时长(单位为秒)")
    private Integer learnTime;

}
