package cn.smarthse.services.train.api.model.question;

import cn.smarthse.services.train.api.entity.question.TrainingQuestionAnswer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * 精准培训试题model
 * @Author liaoly(廖凌云) [1302013247@qq.com]
 * @Date 2021年2月1日 上午9:47:04
 */
@ApiModel(value="精准培训试题", description="精准培训试题")
public @Data class QuestionModel implements Serializable {
	
	private static final long serialVersionUID = 1L;
	
	@ApiModelProperty(value = "试题id")
    private Long id;
	
	@ApiModelProperty(value = "有效区域")
    private Long areaId;

	@ApiModelProperty(value = "题干")
    private String title;

	@ApiModelProperty(value = "使用类别（1、练习题 2、考试题， 逗号分割）")
    private String useType;

	@ApiModelProperty(value = "试题类别（1、单选 2、多选 3、填空）")
    private Integer questionType;

	@ApiModelProperty(value = "适用对象（1-主要负责人 2-职业卫生管理人员 3-劳动者）多个逗号分割")
    private String applyObject;
    
	@ApiModelProperty(value = "正确答案")
    private String correctAnswer;

	@ApiModelProperty(value = "解析")
    private String analysis;

	@ApiModelProperty(value = "状态，  1已入库  2已禁用")
    private Integer state;
	
	@ApiModelProperty(value = "选择题-选项列表")
	List<TrainingQuestionAnswer> questionAnswerList;
}
