package cn.smarthse.services.train.api.model.personal;

import cn.smarthse.services.train.api.enums.personal.UserIntegralTypeEnum;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * 用户积分流水记录
 * @Description 
 * @Author liaoly
 * @Date 2020年4月26日 下午4:11:39
 */
public @Data
class UserIntegralLogModel implements Serializable{
	private static final long serialVersionUID = 1L;
	/**
	 * 
	 */
    @ApiModelProperty(value="")
	private Long id;
	/**
	 * 用户账号id
	 */
    @ApiModelProperty(value="用户账号id")
	private Long userId;
	/**
	 * 本次积分类型
	 */
    @ApiModelProperty(value="本次积分类型(1：挑战答题积分；2：每周答题积分；3：专项答题积分；4：视频学习积分；5：文章学习积分；6：分享积分；7：登入积分；8：APP使用积分)")
	private Integer type;
	/**
	 * 本次积分流水-积分数(有正负，负数代表扣除)
	 */
    @ApiModelProperty(value="本次积分流水-积分数(有正负，负数代表扣除)")
	private Integer integral;
    /**
	 * 积分产生的业务数据id(可能没有)
	 */
    @ApiModelProperty(value="积分产生的业务数据id(可能没有)")
	private Long businessId;
	/**
	 * 创建时间
	 */
    @ApiModelProperty(value="创建时间")
	private java.util.Date createDate;
	/**
	 * 最后修改时间
	 */
    @ApiModelProperty(value="最后修改时间")
	private java.util.Date updateDate;
	/**
	 * 是否有效（0-无效，1-有效）
	 */
    @ApiModelProperty(value="是否有效（0-无效，1-有效）")
	private Boolean isValid;
    
    @ApiModelProperty(value="本次积分类型")
	private String typeStr;
    
    @ApiModelProperty(value="总积分")
	private Integer integralSum;
    
    @ApiModelProperty(value="指定类型的积分的每日上限积分(以UserIntegralTypeEnum为准)")
	private Integer integralMax;
    
    @ApiModelProperty(value="账号")
   	private String username;
    
    @ApiModelProperty(value="用户名")
   	private String fullname;
    
    @ApiModelProperty(value="企业名称")
   	private String companyNames;
    
    public void setType(Integer type) {
    	this.type = type;
    	this.typeStr = UserIntegralTypeEnum.getName(type);
		this.integralMax = UserIntegralTypeEnum.getValueMax(type);
    }
}
