package cn.smarthse.services.train.api.model.member;

import cn.smarthse.services.train.api.entity.question.TrainingQuestionAnswer;
import cn.smarthse.util.common.StringUtils;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;

/**
 * 用户每道题目答题详情model
 * @Author liaoly(廖凌云) [1302013247@qq.com]
 * @Date 2021年2月3日 上午11:32:00
 */
public @Data class ExamLogDetailModel implements Serializable {
	
	private static final long serialVersionUID = -6086926127150212318L;
	
	private Long id;
	
	@ApiModelProperty(value = "考试记录id")
	private Long logId;
	
	@ApiModelProperty(value = "题目id")
	private Long questionId;
	
	@ApiModelProperty(value = "题干")
	private String title;
	
	@ApiModelProperty(value = "使用类别")
	private String useType;
	
	@ApiModelProperty(value = "试题类别")
	private Integer questionType;
	
	@ApiModelProperty(value = "适用对象（1-主要负责人 2-职业卫生管理人员 3-劳动者）多个逗号分割")
	private String applyObject;
	
	@ApiModelProperty(value = "正确答案")
	private String correctAnswer;
	
	@ApiModelProperty(value = "解析")
	private String analysis;
	
	@ApiModelProperty(value = "填写答案")
	private String answer;
	
	@ApiModelProperty(value = "作答时间")
	private LocalDateTime createDate;
	
	@ApiModelProperty(value = "作答时间")
	private boolean isResult;
	
	@ApiModelProperty(value = "选择题-选项列表")
	List<TrainingQuestionAnswer> questionAnswerList;
    
	public boolean isResult() {
		return !StringUtils.isEmpty(answer) && answer.equalsIgnoreCase(this.getCorrectAnswer());
	}
}

