package cn.smarthse.services.train.api.model.exam;


import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * TraningExamTimeModel对象
 * 
 * @Author liaoly(廖凌云) [1302013247@qq.com]
 * @Date 2021年1月28日 下午1:23:55
 */
@ApiModel(value="TraningExamTimeModel对象", description="培训考试时间Model")
public @Data class TrainingExamTimeModel implements Serializable {
	
    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "考试时间id")
    private Long timeId;
    
    @ApiModelProperty(value = "考试结束时间")
    private LocalDateTime endTime;

    @ApiModelProperty(value = "考试地点")
    private String address;

    @ApiModelProperty(value = "满额人数")
    private Integer total;
    
    @ApiModelProperty(value = "考试开始时间")
    private LocalDateTime beginTime;
}
