package cn.smarthse.services.train.api.model.exam;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 考试开始页model
 * 
 * @Author liaoly(廖凌云) [1302013247@qq.com]
 * @Date 2021年1月29日 下午3:24:55
 */
@ApiModel(value="考试开始页model", description="考试开始页model")
public @Data class SummaryExamModelDetail {
	
	@ApiModelProperty(value = "training_exam_time.id 培训考试时间id")
	private Long timeId;
	
	@ApiModelProperty(value = "training_exam_time_member.id")
	private Long timeMemberId;
	
	@ApiModelProperty(value = "training_member.id")
	private Long memberId;
	
	@ApiModelProperty(value = "培训考试类型")
	private String trainingExamType;
	
	@ApiModelProperty(value = "企业名称")
	private String companyName;
	
	@ApiModelProperty(value = "考核题目名")
	private String assessTopic;
	
	@ApiModelProperty(value = "培训考试时长/min")
	private Integer minute;
	
	@ApiModelProperty(value = "及格分数")
	private Integer passScore;
	
	@ApiModelProperty(value = "题目总数")
	private Integer sumNum;
	
	@ApiModelProperty(value = "总分sumScore")
	private Integer sumScore;
	
	@ApiModelProperty(value = "概要")
	private String summary;

	public SummaryExamModelDetail(){}
	
	public SummaryExamModelDetail(Long timeId, Long timeMemberId, Long memberId, 
			String trainingExamType, Integer minute, String companyName, String assessTopic, Integer passScore, Integer sumNum, Integer sumScore) {
		super();
		this.timeId = timeId;
		this.timeMemberId = timeMemberId;
		this.memberId = memberId;
		this.trainingExamType = trainingExamType;
		this.minute = minute;
		this.companyName = companyName;
		this.assessTopic = assessTopic;
		this.passScore = passScore;
		this.sumNum = sumNum;
		this.sumScore = sumScore;
		
		this.initSummary();
	}
	
	/**
	 * 初始化summary
	 * @author liaoly
	 * @date 2021年1月29日 下午4:18:49 void
	 */
	private void initSummary() {
		//本次考试时间限定60分钟，共50道题，满分100分，60分合格。
		StringBuffer sBuffer = new StringBuffer("本次考试时间限定");
		sBuffer.append(minute).append("分钟，共").append(sumNum).append("道题，满分")
			.append(sumScore).append("分，").append(passScore).append("分合格。");
		this.summary = sBuffer.toString();
	}
}
