package cn.smarthse.services.train.api.model.challenganswer;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 用户测试结果表
 * @Description 
 * @Author xiaoyi
 * @Date 2022年5月26日 下午4:11:17
 */
public @Data class UserExamQuestionModel implements Serializable{
	private static final long serialVersionUID = 1L;
	/**
	 * 
	 */
    @ApiModelProperty(value="")
	private Long id;
	/**
	 * 用户账号id
	 */
    @ApiModelProperty(value="用户账号id")
	private Long userId;
    /**
	 * 试卷id(来自exam.id或者exam_challenge.id)
	 */
	private Long examId;
	/**
	 * 试题id
	 */
    @ApiModelProperty(value="试题id")
	private Long questionId;
	/**
	 * 选择题作答结果
	 */
    @ApiModelProperty(value="选择题作答结果")
	private String answer;
	/**
	 * 填空题作答结果
	 */
    @ApiModelProperty(value="填空题作答结果")
	private String fillAnswer;
	/**
	 * 状态(1：草稿 2：已提交)
	 */
    @ApiModelProperty(value="状态(1：草稿 2：已提交)")
	private Integer status;
	/**
	 * 结果判定(对：true；错：false)
	 */
    @ApiModelProperty(value="结果判定(对：true；错：false)")
	private Boolean result;
	/**
	 * 本题得分
	 */
    @ApiModelProperty(value="本题得分")
	private Integer score;
	/**
	 * 创建时间
	 */
    @ApiModelProperty(value="创建时间")
	private Date createDate;
	/**
	 * 最后修改时间
	 */
    @ApiModelProperty(value="最后修改时间")
	private Date updateDate;
    /**
	 * 是否有效（0-无效，1-有效）
	 */
    @ApiModelProperty(value="是否有效（0-无效，1-有效）")
	private Boolean isValid;
    
    @ApiModelProperty(value="当前试题", hidden=true)
    private QuestionWithAnswerModel questionModel;
    
    @ApiModelProperty(value="最后一道试题答题记录id(当前这道试题答题详情userExamQuestionId)")
    private Long lastUserExamQuestionId;
}
