package cn.smarthse.services.train.api.model.challenganswer;


import cn.smarthse.services.train.api.enums.QuestionStatusEnum;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * 试题库-题干
 * @Description 
 * @Author xiaoyi
 * @Date 2022年5月26日 下午4:09:05
 */
public @Data class QuestionWithAnswerModel implements Serializable{
	private static final long serialVersionUID = 1L;
	/**
	 * 
	 */
    @ApiModelProperty(value="")
	private Long id;
    /**
	 * 条目
	 */
    @ApiModelProperty(value="条目(1:职业卫生综合; 2:职业危害防护; 3:职业健康监护; 4:职业危害因素; 5:职业卫生三同时; 6:职业病; 7:放射卫生;)")
	private Integer type;
	/**
	 * 试题类别(1：单选；2：多选；3：填空)
	 */
	@ApiModelProperty(value="试题类别(1：单选；2：多选；3：填空)")
	private Integer questionType;
	/**
	 * 题干(填空题填空位置用"_"标记，app端使用该字符定位)
	 */
    @ApiModelProperty(value="题干(填空题填空位置用“_”标记，app端使用该字符定位)")
	private String stem;
	/**
	 * 答案(可以适当编码)
	 */
    @ApiModelProperty(value="答案(ABCDEF等，多个的话为多选,eg:A：答案A，AB：答案：AB)")
	private String result;
	/**
	 * 解析
	 */
    @ApiModelProperty(value="解析")
	private String analysis;
	/**
	 * 是否专项(专项: true; 不是专项: false)
	 */
    @ApiModelProperty(value="是否专项(专项: true; 不是专项: false)")
	private Boolean isSpecial;
	/**
	 * 试题状态 (1: 未入库; 2: 已入库; 3: 已禁用)
	 */
    @ApiModelProperty(value="试题状态 (1: 未入库; 2: 已入库; 3: 已禁用)")
	private Integer status;
    /**
	 * 替代id，用于随机取数据
	 */
    @ApiModelProperty(value="替代id，用于随机取数据")
	private Integer autoId;
	/**
	 * 权值(成为当前时间的测试试题的概率)
	 */
    @ApiModelProperty(value="权值(成为当前时间的测试试题的概率)")
	private Integer weight;
	/**
	 * 题目分数
	 */
    @ApiModelProperty(value="题目分数")
	private Integer score;
    /**
	 * 选项A
	 */
    @ApiModelProperty(value="选项A")
	private String optionA;
	/**
	 * 选项B
	 */
	@ApiModelProperty(value="选项B")
	private String optionB;
	/**
	 * 选项C
	 */
	@ApiModelProperty(value="选项C")
	private String optionC;
	/**
	 * 选项D
	 */
	@ApiModelProperty(value="选项D")
	private String optionD;
    /**
	 * 填空题的填空数
	 */
    @ApiModelProperty(value="填空题的填空数")
	private Integer fillResultSum;
	/**
	 * 填空题答案(可以适当编码)
	 */
	@ApiModelProperty(value="填空题答案(可以适当编码)")
	private String fillResult;
	/**
	 * 创建人
	 */
    @ApiModelProperty(value="创建人")
	private Long createBy;
	/**
	 * 创建时间
	 */
    @ApiModelProperty(value="创建时间")
	private java.util.Date createDate;
	/**
	 * 最后修改人ID
	 */
    @ApiModelProperty(value="最后修改人ID")
	private Long updateBy;
	/**
	 * 最后修改时间
	 */
    @ApiModelProperty(value="最后修改时间")
	private java.util.Date updateDate;
	/**
	 * 是否有效（0-无效，1-有效）
	 */
    @ApiModelProperty(value="是否有效（0-无效，1-有效）")
	private Boolean isValid;
    
    /**
	 * 试题状态 (1: 未入库; 2: 已入库; 3: 已禁用)
	 */
    @ApiModelProperty(value="试题状态 (1: 未入库; 2: 已入库; 3: 已禁用)")
	private String statusStr;
    
    public void setStatus(Integer status) {
    	
    	this.status = status;
    	
    	if (status == null) return;
    	
    	this.statusStr = QuestionStatusEnum.getByValue(status).getName();
    }
    
    /**
     * 得到导出选择题excel的列名称
     * <li>注：参数为空,默认返回{"题干|stem", "选项A|optionA", "选项B|optionB", "选项C|optionC", "选项D|optionD", "正确答案|result", "解析|analysis"}
     * @param column : 自定义的列编码（以表字段名为准）
     * @return
     */
	public static String[] getRadioHeadArr(String[] column) {
		
		if (column == null || column.length == 0) {
			String[] headArr = 
				{"题干|stem", "选项A|optionA", "选项B|optionB", "选项C|optionC", "选项D|optionD", "正确答案|result", "解析|analysis"};
			return headArr;
		}
		
		//自定义导出列
		String[] headArr = new String[column.length];
		for (int i = 0; i < column.length; i++) {
			switch (headArr[i]) {
			case "stem":
				headArr[i] = "题干|stem";
				break;
			case "optionA":
				headArr[i] = "选项A|optionA";
				break;
			case "optionB":
				headArr[i] = "选项B|optionB";
				break;
			case "optionC":
				headArr[i] = "选项C|optionC";
				break;
			case "optionD":
				headArr[i] = "选项D|optionD"; 
				break;
			case "result":
				headArr[i] = "正确答案|result";
				break;
			case "analysis":
				headArr[i] = "解析|analysis";
				break;
			} //switch
			
		}//for i
		return headArr;
	}
	
	/**
     * 得到导出填空题excel的列名称
     * <li>注：参数为空,默认返回{"题干|stem", "答案|fillResult", "解析|analysis"}
     * @param column : 自定义的列编码（以表字段名为准）
     * @return
     */
	public static String[] getFillHeadArr(String[] column) {
		
		if (column == null || column.length == 0) {
			String[] headArr = 
				{"题干|stem", "答案|fillResult", "解析|analysis"};
			return headArr;
		}
		
		//自定义导出列
		String[] headArr = new String[column.length];
		for (int i = 0; i < column.length; i++) {
			switch (headArr[i]) {
			case "name":
				headArr[i] = "题干|stem";
				break;
			case "code":
				headArr[i] = "答案|fillResult";
				break;
			case "level":
				headArr[i] = "解析|analysis";
				break;
			} //switch
			
		}//for i
		return headArr;
	}
}
