package cn.smarthse.services.train.api.model.challenganswer;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * 查询每周/专项答题列表(按月分类)
 * @Description 
 * @Author xiaoyi
 * @Date 2022年5月26日 下午4:06:45
 */
public @Data class ExamMonthModel implements Serializable{
	private static final long serialVersionUID = 1L;

    @ApiModelProperty(value="测试卷名称(月名称)")
	private String monthName;

    @ApiModelProperty(value="exam表的id)")
	private String examIds;

    @ApiModelProperty(value="每月的测试卷集合)")
	private List<ExamModel> examModels;

    @ApiModelProperty(value="是否作答(1 true：已作答；0 false：未作答)的集合与examIds是一一对应")
    private String isExamStrs;

}
