package cn.smarthse.services.train.api.model.article;

//import cn.smarthse.modules.platform.legal.model.LawItemModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

@ApiModel("文章详情")
public @Data class ArticleModel implements Serializable {
	private static final long serialVersionUID = 1L;

	@ApiModelProperty(value = "")
	private Long id;

	@ApiModelProperty(value = "文章名称")
	private String name;
	
	@ApiModelProperty(value = "文章概要")
	private String summary;

	@ApiModelProperty(value = "文章类别")
	private Integer type;

	@ApiModelProperty(value = "文章来源")
	private String source;

	@ApiModelProperty(value = "法律法规id")
	private Long lawId;

	@ApiModelProperty(value = "文章内容")
	private String content;

	@ApiModelProperty(value = "状态(1: 未上架; 2:已上架; 3:已下架)")
	private Integer status;

	@ApiModelProperty(value = "上架时间")
	private java.util.Date shelvesTime;

	@ApiModelProperty(value = "附件ids")
	private String fileIds;
	
	@ApiModelProperty(value = "编制人")
	private String compiler;

	@ApiModelProperty(value = "创建人")
	private Long createBy;

	@ApiModelProperty(value = "创建时间")
	private java.util.Date createDate;

	@ApiModelProperty(value = "最后修改人ID")
	private Long updateBy;

	@ApiModelProperty(value = "最后修改时间")
	private java.util.Date updateDate;

	@ApiModelProperty(value = "是否有效（0-无效，1-有效）")
	private Boolean isValid;
	
	@ApiModelProperty(value = "文章缩略图sys_file.id， 逗号分隔")
	private String screenshot;
	
	@ApiModelProperty(value = "文章缩略图url")
	private String screenshotUrl;

	/////////////////////////

	@ApiModelProperty(value = "阅读数")
	private Long hot;

	@ApiModelProperty(value = "点赞数")
	private Long up;

	@ApiModelProperty(value = "收藏数")
	private Long collect;

	@ApiModelProperty(value = "是否被当前用户收藏")
	private Boolean isCollect;

	@ApiModelProperty(value = "收藏时间")
	private java.util.Date collectionTime;

	@ApiModelProperty(value = "编制人姓名")
	private String creator;

	// 法律法规的属性

//	@ApiModelProperty(value = "法律法规详情")
//	private LawItemModel law;

}
