package cn.smarthse.services.train.api.model;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * <p>
 * 培训人员表
 * </p>
 *
 * @author yangzp
 * @since 2021-01-21
 */
@Data
public class TransformTrainingMemberModel implements Serializable {

    private Long id;

    @ApiModelProperty(value = "企业id")
    private Long cid;

    @ApiModelProperty(value = "企业名称")
    private String companyName;

    @ApiModelProperty(value = "角色(1:主要负责人 2:职业卫生管理人员 3:劳动者)")
    private Byte role;

    @ApiModelProperty(value = "角色名称")
    private String roleName;

    @ApiModelProperty(value = "人员id")
    private Long staffId;

    @ApiModelProperty(value = "人员姓名")
    private String staffName;

    @ApiModelProperty(value = "性别")
    private String gender;

    @ApiModelProperty(value = "岗位/工种id")
    private Long staffWorkId;

    @ApiModelProperty(value = "岗位/工种名称")
    private String staffWorkName;

    @ApiModelProperty(value = "手机号码")
    private String mobile;

    @ApiModelProperty(value = "培训类别（0-初训 1-复训）")
    private Byte trainingType;
    @ApiModelProperty(value = "培训类别")
    private String trainingTypeStr;

    @ApiModelProperty(value = "培训年度")
    private Integer trainingYear;

    @ApiModelProperty(value = "要求培训学时")
    private Double requireHour;

    @ApiModelProperty(value = "已培训学时")
    private Double trainedHour;

    @ApiModelProperty(value = "预考核状态")
    private Byte testExamState;
    @ApiModelProperty(value = "预考核状态")
    private String testExamStateStr;

    @ApiModelProperty(value = "预考核时间")
    private Date testExamTime;

    @ApiModelProperty(value = "考试状态（0-未考试 1-已考试，合格 2-已考试，不合格）")
    private Byte examState;
    @ApiModelProperty(value = "考试状态")
    private String examStateStr;

    @ApiModelProperty(value = "考试时间")
    private Date examTime;

}
