package cn.smarthse.services.train.api.model;

import cn.smarthse.common.util.DateUtils;
import cn.smarthse.common.util.IDCardUtil;
import cn.smarthse.modules.health.enums.staff.StaffGenderEnum;
import cn.smarthse.services.train.api.enums.ExamStateEnum;
import cn.smarthse.services.train.api.enums.TrainMemberRoleEnum;
import cn.smarthse.services.train.api.enums.TrainingTypeEnum;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.util.StringUtils;

import java.io.Serializable;
import java.util.Date;

/**
 * @program:
 * @description:
 * @author: yzp
 * @create: 2021/1/22 10:27
 */
public @Data
class TrainingMemberModel implements Serializable {
    private Long id;

    @ApiModelProperty(value = "企业id")
    private Long cid;

    @ApiModelProperty(value = "公司名称")
    private String companyName;
    @ApiModelProperty(value = "行业分类")
    private Long industryCategory;

    @ApiModelProperty(value = "角色")
    private Byte role;

    @ApiModelProperty(value = "人员id")
    private Long staffId;

    @ApiModelProperty(value = "人员姓名")
    private String staffName;

    @ApiModelProperty(value = "性别(0:女 1:男)")
    private Byte gender;

    @ApiModelProperty(value = "岗位/工种id")
    private Long staffWorkId;

    @ApiModelProperty(value = "岗位/工种名称")
    private String staffWorkName;


    @ApiModelProperty(value = "手机号码")
    private String mobile;

    @ApiModelProperty(value = "培训类别")
    private Byte trainingType;

    @ApiModelProperty(value = "培训年度")
    private Integer trainingYear;

    @ApiModelProperty(value = "要求培训学时")
    private Integer requireHour;

    @ApiModelProperty(value = "已培训学时")
    private Integer trainedHour;

    @ApiModelProperty(value = "预考核状态")
    private Byte testExamState;

    @ApiModelProperty(value = "预考核时间")
    private Date testExamTime;

    @ApiModelProperty(value = "考试状态")
    private Byte examState;

    @ApiModelProperty(value = "考试时间")
    private Date examTime;

    private String examTimeStr;



    private String roleName;

    private String genderStr;

    private String idCard;

    private String trainingTypeStr;

    private String examStateStr;

    private String roleStr;

    public String getGenderStr(){
        if (null != gender){
            return genderStr = gender == StaffGenderEnum.MALE.getValue().byteValue() ? "男" : "女";
        }else if(StringUtils.isEmpty(idCard)){
            genderStr = IDCardUtil.getGenderName(idCard);
        }
        return genderStr;
    }
    public String getExamStateStr(){
        if (null != examState){
            if (examState != ExamStateEnum.status0.getValue().byteValue()){
                return examStateStr = examState == ExamStateEnum.status1.getValue().byteValue() ? "已考试,合格" : "已考试,不合格";
            }
            return examStateStr = "未考试";
        }
        return examStateStr;
    }

    public String getTrainingType(){
        if (null != trainingType){
            return trainingTypeStr = trainingType.equals(TrainingTypeEnum.first_1.getType())  ? "初训" : "复训";
        }
        return trainingTypeStr;
    }

    public String getExamTimeStr(){
        if (null != examTime){
            return DateUtils.getDate(examTime);
        }
        return null;
    }

    public String getRoleStr(){
        if (null != role){
            if (role != TrainMemberRoleEnum.status3.getValue().byteValue()){
                return roleStr = role == TrainMemberRoleEnum.status1.getValue().byteValue() ? "主要负责人" : "职业卫生管理员";
            }
            return roleStr = "劳动者";
        }
        return roleStr;
    }
}
