package cn.smarthse.services.train.api.enums.video;

import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 视频学习状态(0 ,未学习; 1, 学习中 ;2,已学习)
 * 
 * @Author liaoly(廖凌云) [1302013247@qq.com]
 * @Date 2021年2月5日 下午12:02:50
 */
@JsonFormat(shape = JsonFormat.Shape.OBJECT)
public enum VideoMemberStateEnum {
	
	/**
	 * 未学习
	 */
    unlearn_0("未学习",0, "0"),

    /**
     * 学习中
     */
    learning_1("学习中",1, "1"),
    
    /**
     * 已学习
     */
    learn_ed_2("已学习",2, "2"),

    ;

    // 成员变量
    private String name;
    private Integer value;
    private String type;
    // 构造方法

    private VideoMemberStateEnum(String name, Integer value, String type) {
        this.name = name;
        this.value = value;
        this.type = type;
    }
    // 普通方法
    public static String getName(Integer value) {
        if (value == null) {
            return null;
        }
        for (VideoMemberStateEnum c : VideoMemberStateEnum.values()) {
            if (c.getValue().equals(value)) {
                return c.name;
            }
        }
        return null;
    }


    // get set 方法
    public String getName() {
        return name;
    }
    public void setName(String name) {
        this.name = name;
    }
    public Integer getValue() {
        return value;
    }
    public void setValue(Integer index) {
        this.value = index;
    }
	public String getType() {
		return type;
	}
	public void setType(String type) {
		this.type = type;
	}
}
