package cn.smarthse.services.train.api.enums.question;


import cn.smarthse.util.common.StringUtils;

/**
 * 培训试题类型枚举（1、单选 2、多选 3、填空）
 * 
 * @Author liaoly(廖凌云) [1302013247@qq.com]
 * @Date 2021年2月1日 上午10:20:59
 */
public enum TrainingQuestionTypeEnum {
	
    question_single_1("单选", 1),
    
    question_multiple_2("多选", 2),
    
    question_fill_2("填空", 3),

    ;

    // 成员变量
    private String name;
    
    private Integer value;
    
    private TrainingQuestionTypeEnum(String name, Integer value) {
        this.name = name;
        this.value = value;
    }
    
    public static String getName(Integer value) {
        if (value == null) {
            return null;
        }
        for (TrainingQuestionTypeEnum c : TrainingQuestionTypeEnum.values()) {
            if (c.getValue().equals(value)) {
                return c.name;
            }
        }
        return null;
    }
    
    public static Integer getValueByName(String name) {
        if (StringUtils.isEmpty(name)) {
            return null;
        }
        for (TrainingQuestionTypeEnum c : TrainingQuestionTypeEnum.values()) {
            if (c.getName().equals(name)) {
                return c.getValue();
            }
        }
        return null;
    }

    public String getName() {
        return name;
    }
    
    public void setName(String name) {
        this.name = name;
    }

	public Integer getValue() {
		return value;
	}

	public void setValue(Integer value) {
		this.value = value;
	}
}
